/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cli;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.gdface.cli.CmdConfig;
import net.gdface.cli.CommonCliConstants;
import net.gdface.cli.Context;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class AbstractConfiguration
extends Context
implements CommonCliConstants,
CmdConfig {
    protected abstract Map<String, Object> getDefaultValueMap();

    @Override
    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        Iterator<Option> it = options.getOptions().iterator();
        Map<String, Object> defaultMap = this.getDefaultValueMap();
        if (defaultMap == null) {
            defaultMap = Collections.emptyMap();
        }
        while (it.hasNext()) {
            Object value;
            Option opt = it.next();
            String key = opt.getLongOpt() == null ? opt.getOpt() : opt.getLongOpt();
            if (!this.isNeedOption(key)) continue;
            try {
                value = opt.hasArg() ? cmd.getParsedOptionValue(key) : Boolean.valueOf(cmd.hasOption(key));
            }
            catch (NoClassDefFoundError e) {
                System.out.printf("key=%s %s\n", key, cmd.getOptionValue(key));
                throw e;
            }
            if (null == value) {
                if (opt.isRequired()) {
                    throw new IllegalArgumentException(String.format("%s or %s not define", opt.getOpt(), opt.getLongOpt()));
                }
                if (!defaultMap.containsKey(key)) {
                    throw new IllegalArgumentException(String.format("%s or %s not default value", opt.getOpt(), opt.getLongOpt()));
                }
                value = defaultMap.get(key);
            }
            this.setProperty(key, value);
        }
    }

    private final boolean isNeedOption(String opt) {
        return !CONTROL_OPTIONS.contains(opt);
    }
}

