/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassResourceUtils {
    private static final FilenameFilter FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return new File(dir, name).isFile();
        }
    };
    private static final String PROTOCOL_FILE = "file";
    private static final String PROTOCOL_JAR = "jar";

    public static List<String> getFilesUnchedked(Class<?> clazz, String path) {
        try {
            return ClassResourceUtils.getResourceFileList(ClassResourceUtils.class, path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getFilesUnchecked(Class<?> clazz, String path, FileFilter filter) {
        List<String> list = ClassResourceUtils.getFilesUnchedked(clazz, path);
        if (null != filter) {
            Iterator<String> itor = list.iterator();
            while (itor.hasNext()) {
                String file = itor.next();
                if (filter.accept(file)) continue;
                itor.remove();
            }
        }
        return list;
    }

    public static boolean resourceExist(Class<?> clazz, String resource) {
        return ClassResourceUtils.getResource(clazz, resource) != null;
    }

    public static String normalizePath(String path) {
        int index;
        String normalized = path;
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("%20")) >= 0) {
            normalized = normalized.substring(0, index) + " " + normalized.substring(index + 3);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String normalizeDirPath(String path) {
        if ((path = ClassResourceUtils.normalizePath(path)).startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String name) {
        URL url = ClassResourceUtils.getResource(clazz, name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL getResource(Class<?> claz, String path) {
        URL result = null;
        path = ClassResourceUtils.normalizePath(path);
        path = path.substring(1);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = claz.getClassLoader();
            result = classLoader.getResource(path);
        } else {
            result = classLoader.getResource(path);
            if (result == null && (classLoader = claz.getClassLoader()) != null) {
                result = classLoader.getResource(path);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResourceFileList(Class<?> clazz, String dirPath) throws IOException {
        if (null == dirPath || dirPath.isEmpty()) {
            throw new IllegalArgumentException("path must not be null or empty");
        }
        URL dirURL = ClassResourceUtils.getResource(clazz, dirPath = ClassResourceUtils.normalizeDirPath(dirPath));
        if (null == dirURL) {
            throw new FileNotFoundException(dirPath);
        }
        if (PROTOCOL_FILE.equals(dirURL.getProtocol())) {
            return new ArrayList<String>(Arrays.asList(new File(URI.create(dirURL.toString())).list(FILE_FILTER)));
        }
        if (PROTOCOL_JAR.equals(dirURL.getProtocol())) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            LinkedList<String> result = new LinkedList<String>();
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String element;
                    int checkSubdir;
                    String name;
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(name = entry.getName()).startsWith(dirPath) || (checkSubdir = (element = name.substring(dirPath.length())).indexOf("/")) >= 0) continue;
                    result.add(element);
                }
            }
            return result;
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    public static interface FileFilter {
        public boolean accept(String var1);
    }
}

