/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;

public class NetworkUtil {
    public static final String DEFAULT_HOST = "localhost";
    private static byte[][] invalidMacs = new byte[][]{{0, 5, 105}, {0, 28, 20}, {0, 12, 41}, {0, 80, 86}, {8, 0, 39}, {10, 0, 39}, {0, 3, -1}, {0, 21, 93}};

    @SafeVarargs
    public static Set<NetworkInterface> getNICs(Predicate<NetworkInterface> ... filters) {
        if (null == filters) {
            filters = new Predicate[]{Filter.ALL};
        }
        try {
            UnmodifiableIterator<NetworkInterface> filtered = Iterators.filter(Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), Predicates.and(filters));
            return ImmutableSet.copyOf(filtered);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<NetworkInterface> getPhysicalNICs() {
        return NetworkUtil.getNICs(Filter.PHYICAL_ONLY, Filter.UP);
    }

    public static final String format(byte[] source, String separator, final Radix radix) {
        if (null == source) {
            return "";
        }
        if (null == separator) {
            separator = "";
        }
        List<String> hex = Lists.transform(Bytes.asList(source), new Function<Byte, String>(){

            @Override
            public String apply(Byte input) {
                return Integer.toString(input & 0xFF, radix.value);
            }
        });
        return Joiner.on(separator).join(hex);
    }

    public static final String formatMac(byte[] source, String separator) {
        return NetworkUtil.format(source, separator, Radix.HEX);
    }

    public static final String formatIp(byte[] source) {
        return NetworkUtil.format(source, ".", Radix.DEC);
    }

    public static byte[] getMacAddress(InetAddress address) {
        try {
            NetworkInterface nic = NetworkInterface.getByInetAddress(address);
            return null == nic ? null : nic.getHardwareAddress();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMacAddress(NetworkInterface nic, String separator) {
        try {
            return NetworkUtil.format(nic.getHardwareAddress(), separator, Radix.HEX);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMacAddress(InetAddress address, String separator) {
        return NetworkUtil.format(NetworkUtil.getMacAddress(address), separator, Radix.HEX);
    }

    private static boolean isVMMac(byte[] mac) {
        if (null == mac) {
            return false;
        }
        for (byte[] invalid : invalidMacs) {
            if (invalid[0] != mac[0] || invalid[1] != mac[1] || invalid[2] != mac[2]) continue;
            return true;
        }
        return false;
    }

    public static final boolean isLoopbackAddress(String host) {
        return "127.0.0.1".equals(host) || "::1".equals(host) || DEFAULT_HOST.equals(host);
    }

    public static final boolean isLocalhost(InetAddress address) {
        try {
            return address.isLoopbackAddress() || InetAddress.getLocalHost().getHostAddress().equals(address.getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static final boolean isLocalhost(String host) {
        try {
            return NetworkUtil.isLoopbackAddress(host) || NetworkUtil.isLocalhost(InetAddress.getByName(Preconditions.checkNotNull(host)));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static final String convertHost(String host) {
        return NetworkUtil.isLoopbackAddress(host) ? DEFAULT_HOST : host;
    }

    public static boolean selfBind(final InetAddress address) {
        if (NetworkUtil.isLocalhost(address)) {
            return true;
        }
        final Predicate<InetAddress> filter = new Predicate<InetAddress>(){

            @Override
            public boolean apply(InetAddress input) {
                return input.getHostAddress().equals(address.getHostAddress());
            }
        };
        return Iterators.tryFind(NetworkUtil.getPhysicalNICs().iterator(), new Predicate<NetworkInterface>(){

            @Override
            public boolean apply(NetworkInterface input) {
                return Iterators.tryFind(Iterators.forEnumeration(input.getInetAddresses()), filter).isPresent();
            }
        }).isPresent();
    }

    public static boolean selfBind(String host) {
        try {
            return NetworkUtil.selfBind(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getCurrentMac(String host, int port) throws IOException {
        try (Socket socket = null;){
            socket = new Socket(host, port);
            InetAddress address = socket.getLocalAddress();
            NetworkInterface nic = NetworkInterface.getByInetAddress(address);
            byte[] byArray = nic.getHardwareAddress();
            return byArray;
        }
    }

    public static enum Filter implements Predicate<NetworkInterface>
    {
        ALL,
        UP,
        VIRTUAL,
        LOOPBACK,
        PHYICAL_ONLY;


        @Override
        public boolean apply(NetworkInterface input) {
            if (null == input) {
                return false;
            }
            try {
                switch (this) {
                    case UP: {
                        return input.isUp();
                    }
                    case VIRTUAL: {
                        return input.isVirtual();
                    }
                    case LOOPBACK: {
                        return input.isLoopback();
                    }
                    case PHYICAL_ONLY: {
                        byte[] hardwareAddress = input.getHardwareAddress();
                        return null != hardwareAddress && hardwareAddress.length > 0 && !input.isVirtual() && !NetworkUtil.isVMMac(hardwareAddress);
                    }
                }
                return true;
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum Radix {
        BIN(2),
        DEC(10),
        HEX(16);

        public final int value;

        private Radix(int radix) {
            this.value = radix;
        }
    }
}

