/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ForwardingMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReflectionUtils {
    public static final String PROP_CLASSNAME = "className";
    public static final String PROP_STATICMETHODNAME = "staticMethodName";
    public static final String PROP_PARAMETERTYPES = "parameterTypes";
    public static final String PROP_CONSTRUCTORARGS = "constructorArgs";
    public static final String PROP_CONSTRUCTORPARAMS = "constructorParams";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> Class<? extends T> getInstanceClass(Class<T> superClass, String instanceClassName) throws ClassNotFoundException {
        Preconditions.checkArgument(null != superClass && !Strings.isNullOrEmpty(instanceClassName));
        Class<?> instanceClass = Class.forName(instanceClassName);
        ReflectionUtils.checkInstanceClass(superClass, instanceClass);
        return instanceClass;
    }

    public static <T> T getInstance(Class<T> superClass, Map<String, Object> params) throws NoSuchMethodException, ClassNotFoundException {
        ParameterMap paramMap = new ParameterMap(params);
        String clazzName = (String)paramMap.of(PROP_CLASSNAME);
        Class<T> instanceClass = ReflectionUtils.getInstanceClass(superClass, clazzName);
        String staticMethodName = (String)paramMap.of(PROP_STATICMETHODNAME);
        if (null != staticMethodName) {
            try {
                return ReflectionUtils.getInstanceByStaticMethod(superClass, instanceClass, staticMethodName);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (paramMap.containsKey(PROP_CONSTRUCTORPARAMS)) {
            LinkedHashMap constructorParams = (LinkedHashMap)paramMap.of(PROP_CONSTRUCTORPARAMS);
            return ReflectionUtils.getInstanceByConstructor(superClass, instanceClass, constructorParams);
        }
        Class[] parameterTypes = (Class[])paramMap.of(PROP_PARAMETERTYPES);
        Object[] ctorArgs = (Object[])paramMap.of(PROP_CONSTRUCTORARGS);
        return ReflectionUtils.getInstanceByConstructor(superClass, instanceClass, parameterTypes, ctorArgs);
    }

    private static void checkInstanceClass(Class<?> superClass, Class<?> instanceClass) {
        Preconditions.checkArgument(null != superClass && null != instanceClass);
        Preconditions.checkArgument(!instanceClass.isInterface() && superClass.isAssignableFrom(instanceClass), "%s not a implemenation of %s", (Object)instanceClass.getName(), (Object)superClass.getSimpleName());
        Preconditions.checkArgument(!Modifier.isAbstract(instanceClass.getModifiers()), "%s is abstract class", (Object)instanceClass.getName());
        Preconditions.checkArgument(Modifier.isStatic(instanceClass.getModifiers()) || null == instanceClass.getDeclaringClass(), "%s is not static class", (Object)instanceClass.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getInstanceByConstructor(Class<T> superClass, Class<? extends T> instanceClass, Class<?>[] parameterTypes, Object[] constructorArgs) throws NoSuchMethodException {
        ReflectionUtils.checkInstanceClass(superClass, instanceClass);
        parameterTypes = MoreObjects.firstNonNull(parameterTypes, EMPTY_CLASS_ARRAY);
        constructorArgs = MoreObjects.firstNonNull(constructorArgs, EMPTY_OBJECT_ARRAY);
        Preconditions.checkArgument(parameterTypes.length == constructorArgs.length);
        Constructor<T> ctor = instanceClass.getConstructor(parameterTypes);
        try {
            T t = ctor.newInstance(constructorArgs);
            return t;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T getInstanceByConstructor(Class<T> superClass, Class<? extends T> instanceClass, LinkedHashMap<Class<?>, Object> constructorParams) throws NoSuchMethodException {
        ReflectionUtils.checkInstanceClass(superClass, instanceClass);
        constructorParams = MoreObjects.firstNonNull(constructorParams, new LinkedHashMap());
        Class[] parameterTypes = constructorParams.keySet().toArray(new Class[constructorParams.size()]);
        Object[] initargs = constructorParams.values().toArray(new Object[constructorParams.size()]);
        Constructor<T> ctor = instanceClass.getConstructor(parameterTypes);
        try {
            return ctor.newInstance(initargs);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T getInstanceByStaticMethod(Class<T> superClass, Class<? extends T> instanceClass, String staticMethodName) throws NoSuchMethodException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(staticMethodName));
        ReflectionUtils.checkInstanceClass(superClass, instanceClass);
        try {
            Method method = instanceClass.getMethod(staticMethodName, new Class[0]);
            Preconditions.checkArgument(Modifier.isStatic(method.getModifiers()), "%s is not a static method", (Object)method.toString());
            Preconditions.checkArgument(superClass.isAssignableFrom(method.getReturnType()), "unexpect return type %s", (Object)method.getReturnType().toString());
            try {
                return (T)method.invoke(null, new Object[0]);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("invalid return type of static method %s caused by %s", method.toString(), e.getMessage()));
            }
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    private static class ParameterMap
    extends ForwardingMap<String, Object> {
        private final Map<String, Object> delegate;

        public ParameterMap(Map<String, Object> delegate) {
            this.delegate = null == delegate ? Collections.emptyMap() : delegate;
        }

        @Override
        protected Map<String, Object> delegate() {
            return this.delegate;
        }

        public final <T> T of(String key, T defaultValue) {
            Preconditions.checkArgument(null != key);
            Object value = this.delegate.get(key);
            try {
                return (T)(null == value ? defaultValue : value);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("invalid parameter: " + key + ",caused by " + e.getMessage());
            }
        }

        public final <T> T of(String key) {
            return this.of(key, null);
        }
    }
}

