/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class ShareLock
implements Lock {
    private final int maxShareCount;
    private final Sync sync;

    public ShareLock(int maxShareCount) {
        this.maxShareCount = maxShareCount;
        this.sync = new Sync(this.maxShareCount);
    }

    @Override
    public void lock() {
        this.sync.acquireShared(1);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        return this.sync.tryAcquireShared(1) >= 0;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(time));
    }

    @Override
    public void unlock() {
        this.sync.releaseShared(1);
    }

    public int getMaxShareCount() {
        return this.maxShareCount;
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -3340303865224708218L;
        private final ThreadLocal<Integer> threadLockCount = new ThreadLocal();

        Sync(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("maxShareCount must large than zero.");
            }
            this.setState(count);
        }

        @Override
        public int tryAcquireShared(int acquireCount) {
            Integer tlc = this.threadLockCount.get();
            if (null == tlc) {
                int newCount;
                int current;
                do {
                    if ((newCount = (current = this.getState()) - acquireCount) >= 0) continue;
                    return newCount;
                } while (!this.compareAndSetState(current, newCount));
                this.threadLockCount.set(acquireCount);
                return newCount;
            }
            tlc = tlc + acquireCount;
            return this.getState();
        }

        @Override
        public boolean tryReleaseShared(int releaseCount) {
            int newCount;
            int current;
            Integer tlc = this.threadLockCount.get();
            if (null == tlc || tlc <= 0) {
                throw new IllegalStateException("Error threadLockCount");
            }
            if ((tlc = Integer.valueOf(tlc - releaseCount)) > 0) {
                return true;
            }
            if (tlc != 0) {
                throw new IllegalStateException("Error threadLockCount");
            }
            while (!this.compareAndSetState(current = this.getState(), newCount = current + releaseCount)) {
            }
            this.threadLockCount.set(null);
            return true;
        }
    }
}

