/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeUtils {
    public static void traverseTypes(Type type, Action action) {
        Preconditions.checkArgument(null != action, "action is null");
        if (type instanceof Class) {
            action.doClass((Class)type);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            Type rawType = paramType.getRawType();
            Type[] typeArgs = paramType.getActualTypeArguments();
            TypeUtils.traverseTypes(rawType, action);
            for (Type arg : typeArgs) {
                TypeUtils.traverseTypes(arg, action);
            }
        } else if (type instanceof GenericArrayType) {
            TypeUtils.traverseTypes(((GenericArrayType)type).getGenericComponentType(), action);
        } else if (type instanceof TypeVariable) {
            for (Type t : ((TypeVariable)type).getBounds()) {
                TypeUtils.traverseTypes(t, action);
            }
        } else if (type instanceof WildcardType) {
            for (Type t : ((WildcardType)type).getLowerBounds()) {
                TypeUtils.traverseTypes(t, action);
            }
            for (Type t : ((WildcardType)type).getUpperBounds()) {
                TypeUtils.traverseTypes(t, action);
            }
        } else {
            throw new IllegalArgumentException(String.format("not allow type %s", type.toString()));
        }
    }

    public static <K, V> TypeToken<Map<K, V>> mapToken(TypeToken<K> keyToken, TypeToken<V> valueToken) {
        return new TypeToken<Map<K, V>>(){}.where(new TypeParameter<K>(){}, keyToken).where(new TypeParameter<V>(){}, valueToken);
    }

    public static <T> TypeToken<List<T>> listToken(TypeToken<T> keyToken) {
        return new TypeToken<List<T>>(){}.where(new TypeParameter<T>(){}, keyToken);
    }

    public static <T> TypeToken<Set<T>> setToken(TypeToken<T> keyToken) {
        return new TypeToken<Set<T>>(){}.where(new TypeParameter<T>(){}, keyToken);
    }

    public static interface Action {
        public void doClass(Class<?> var1);
    }
}

