/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class NumberValidator<T>
implements Predicate<T> {
    public static final NumberValidator<Object> DEFAULT_VALIDATOR = new NumberValidator();
    public static final NumberValidator<Object> NORMALIZATION_VALIDATOR = new NumberValidator<Double>(0.0, true, 1.0, true);
    private T min = null;
    private T max = null;
    private LinkedHashSet<T> values = null;
    private Comparator<T> numCcomparator = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            if (o1 instanceof Integer && o2 instanceof Integer) {
                return ((Integer)o1).compareTo((Integer)o2);
            }
            if (o1 instanceof Short && o2 instanceof Short) {
                return ((Short)o1).compareTo((Short)o2);
            }
            if (o1 instanceof Byte && o2 instanceof Byte) {
                return ((Byte)o1).compareTo((Byte)o2);
            }
            if (o1 instanceof Float && o2 instanceof Float) {
                return ((Float)o1).compareTo((Float)o2);
            }
            if (o1 instanceof Float && o2 instanceof Float) {
                return ((Float)o1).compareTo((Float)o2);
            }
            if (o1 instanceof Double && o2 instanceof Double) {
                return ((Double)o1).compareTo((Double)o2);
            }
            throw new IllegalArgumentException("UNSUPPORTED TYPE");
        }
    };
    private boolean mineq;
    private boolean maxeq;

    public NumberValidator() {
        this(null, true, null, true);
    }

    public NumberValidator(T min, boolean mineq, T max, boolean maxeq) {
        this.min = min;
        this.max = max;
        this.mineq = mineq;
        this.maxeq = maxeq;
        Preconditions.checkArgument(min == null || Number.class.isAssignableFrom(min.getClass()));
        Preconditions.checkArgument(max == null || Number.class.isAssignableFrom(max.getClass()));
        if (min != null && max != null) {
            Preconditions.checkArgument(this.numCcomparator.compare(min, max) < 0, "value of max must less than min");
        }
    }

    @SafeVarargs
    public NumberValidator(T ... values) {
        this.values = Sets.newLinkedHashSet(Iterables.filter(Arrays.asList(Preconditions.checkNotNull(values)), Predicates.notNull()));
        Preconditions.checkArgument(!this.values.isEmpty(), "EMPTY LIST FOR values");
        Iterables.any(this.values, new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                Preconditions.checkArgument(input instanceof Number, "INVALID type of values");
                return true;
            }
        });
    }

    @Override
    public boolean apply(T input) {
        int comp;
        if (input == null) {
            return false;
        }
        if (this.values != null) {
            return this.values.contains(input);
        }
        boolean check = true;
        if (this.min != null) {
            comp = this.numCcomparator.compare(this.min, input);
            boolean bl = check = check && (this.mineq && comp <= 0 || comp < 0);
        }
        if (this.max != null) {
            comp = this.numCcomparator.compare(input, this.max);
            check = check && (this.maxeq && comp >= 0 || comp > 0);
        }
        return check;
    }

    public String toString() {
        int maxLen = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("NumberValidator [");
        if (this.min != null) {
            builder.append("min=");
            builder.append(this.min);
            builder.append(", ");
        }
        if (this.max != null) {
            builder.append("max=");
            builder.append(this.max);
            builder.append(", ");
        }
        if (this.values != null) {
            builder.append("values=");
            builder.append(this.toString(this.values, 10));
            builder.append(", ");
        }
        if (this.numCcomparator != null) {
            builder.append("numCcomparator=");
            builder.append(this.numCcomparator);
        }
        builder.append("]");
        return builder.toString();
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    @SafeVarargs
    public static final <T> Predicate<Object> makeValidator(T ... values) {
        Preconditions.checkArgument(values != null && values.length > 1);
        return new NumberValidator<Object>(values);
    }

    public static final <T> Predicate<Object> makeValidator(T min, boolean mineq, T max, boolean maxeq) {
        return new NumberValidator<Object>(min, mineq, max, maxeq);
    }
}

