/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import gu.dtalk.Base64Option;
import gu.dtalk.BaseOption;
import gu.dtalk.BoolOption;
import gu.dtalk.CheckOption;
import gu.dtalk.DateOption;
import gu.dtalk.FloatOption;
import gu.dtalk.IPv4Option;
import gu.dtalk.ImageOption;
import gu.dtalk.IntOption;
import gu.dtalk.MACOption;
import gu.dtalk.OptionBuilder;
import gu.dtalk.PasswordOption;
import gu.dtalk.StringOption;
import gu.dtalk.SwitchOption;
import gu.dtalk.UrlOption;
import gu.simplemq.json.BaseJsonEncoder;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.gdface.utils.FaceUtilits;

public enum OptionType {
    STRING(StringOption.class),
    INTEGER(IntOption.class),
    FLOAT(FloatOption.class),
    BOOL(BoolOption.class),
    DATE(DateOption.class),
    URL(UrlOption.class),
    PASSWORD(PasswordOption.class),
    EMAIL(StringOption.class, "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$"),
    MPHONE(StringOption.class, "^(13[0-9]|14[5|7]|15[0|1|2|3|5|6|7|8|9]|18[0|1|2|3|5|6|7|8|9])\\d{8}$"),
    IDNUM(StringOption.class, "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)"),
    BASE64(Base64Option.class),
    MAC(MACOption.class, "^([a-fA-F0-9]{2}[:-]?){5}[a-fA-F0-9]{2}$"),
    IP(IPv4Option.class, "^((?:(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d))$"),
    IMAGE(ImageOption.class),
    MULTICHECK(CheckOption.class, "^\\s*(\\d+)?([,;\\s]+\\d+)*\\s*$"),
    SWITCH(SwitchOption.class, "^\\s*\\d+\\s*$");

    final String regex;
    private volatile Type targetType;
    final Class<? extends BaseOption> optClass;
    public final Predicate<String> strValidator = new Predicate<String>(){

        @Override
        public boolean apply(String input) {
            if (OptionType.this.regex.isEmpty()) {
                return true;
            }
            return input != null && input.matches(OptionType.this.regex);
        }
    };
    private static final Cache<OptionType, Function<String, ?>> cache;

    private <T, B extends BaseOption<T>> OptionType(Class<B> implClass) {
        this(implClass, "");
    }

    private <T, B extends BaseOption<T>> OptionType(Class<B> implClass, String regex) {
        this.optClass = Preconditions.checkNotNull(implClass, "implClass is null");
        this.regex = Preconditions.checkNotNull(regex, "regex is null");
    }

    private <T> Function<String, T> internalTrans() {
        switch (this) {
            case EMAIL: 
            case MPHONE: 
            case IDNUM: {
                return new Function<String, String>(){

                    @Override
                    public String apply(String input) {
                        Preconditions.checkArgument(OptionType.this.strValidator.apply(input), "INVALID FORMAT '%s' FOR %s", (Object)input, (Object)OptionType.this.name());
                        return input;
                    }
                };
            }
            case DATE: {
                return new Function<String, Date>(){

                    @Override
                    public Date apply(String input) {
                        Date date = null;
                        if (null != input) {
                            try {
                                date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(input);
                            }
                            catch (ParseException e) {
                                try {
                                    date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(input);
                                }
                                catch (ParseException e1) {
                                    try {
                                        date = new SimpleDateFormat("yyyy-MM-dd").parse(input);
                                    }
                                    catch (ParseException e2) {
                                        try {
                                            date = new SimpleDateFormat("HH:mm:ss").parse(input);
                                        }
                                        catch (ParseException e3) {
                                            throw new IllegalArgumentException(String.format("INVALID FORMAT '%s' FOR %s", input, OptionType.this.name()));
                                        }
                                    }
                                }
                            }
                        }
                        return date;
                    }
                };
            }
            case MAC: {
                return new Function<String, byte[]>(){

                    @Override
                    public byte[] apply(String input) {
                        Preconditions.checkArgument(OptionType.this.strValidator.apply(input), "INVALID FORMAT '%s' FOR %s", (Object)input, (Object)OptionType.this.name());
                        String hex = input.replace(":", "");
                        return FaceUtilits.hex2Bytes(hex);
                    }
                };
            }
            case IP: {
                return new Function<String, byte[]>(){

                    @Override
                    public byte[] apply(String input) {
                        Preconditions.checkArgument(OptionType.this.strValidator.apply(input), "INVALID FORMAT '%s' FOR %s", (Object)input, (Object)OptionType.this.name());
                        String[] ip = input.split("\\.");
                        byte[] parseByte = new byte[ip.length];
                        for (int i = 0; i < parseByte.length; ++i) {
                            parseByte[i] = (byte)(Integer.valueOf(ip[i]) & 0xFF);
                        }
                        return parseByte;
                    }
                };
            }
            case MULTICHECK: 
            case SWITCH: {
                return new Function<String, Set<Integer>>(){

                    @Override
                    public Set<Integer> apply(String input) {
                        Preconditions.checkArgument(OptionType.this.strValidator.apply(input), "INVALID FORMAT '%s' FOR %s", (Object)input, (Object)OptionType.this.name());
                        String[] numlist = input.split("[;,\\s]+");
                        HashSet<Integer> set = Sets.newHashSet();
                        for (String num : numlist) {
                            if (num.isEmpty()) continue;
                            set.add(Integer.valueOf(num));
                        }
                        return set;
                    }
                };
            }
        }
        return new DefaultStringTransformer(this.getTargetType());
    }

    public <T> Function<String, T> trans() {
        try {
            return cache.get(this, new Callable<Function<String, T>>(){

                @Override
                public Function<String, T> call() throws Exception {
                    return OptionType.this.internalTrans();
                }
            });
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked(e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    private void refreshValueIfTransPresent(Map<String, Object> json, String name) {
        Function t = this.trans();
        if (!(t instanceof DefaultStringTransformer) && null != json.get(name)) {
            String valuestr = json.get(name).toString();
            try {
                Object parsed = t.apply(valuestr);
                if (parsed != null) {
                    json.put(name, parsed);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public <T, O extends BaseOption<T>> OptionBuilder<T, O> builder() {
        return OptionBuilder.builder(this);
    }

    public static BaseOption<?> parseOption(Map<String, Object> json) {
        OptionType optionType = TypeUtils.cast(Preconditions.checkNotNull(json.get("type"), "NOT FOUND %s field", (Object)"type"), OptionType.class, ParserConfig.getGlobalInstance());
        optionType.refreshValueIfTransPresent(json, "value");
        optionType.refreshValueIfTransPresent(json, "defaultValue");
        return BaseJsonEncoder.getEncoder().fromJson(JSON.toJSONString(json), optionType.optClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type getTargetType() {
        if (null == this.targetType) {
            OptionType optionType = this;
            synchronized (optionType) {
                if (this.targetType == null) {
                    try {
                        this.targetType = this.optClass.newInstance().type;
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked(e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.targetType;
    }

    public Class<? extends BaseOption> optionClass() {
        return this.optClass;
    }

    static {
        cache = CacheBuilder.newBuilder().build();
    }

    private class DefaultStringTransformer<T>
    implements Function<String, T> {
        private final Type type;

        public DefaultStringTransformer(Type type) {
            this.type = Preconditions.checkNotNull(type, "type is null");
        }

        @Override
        public T apply(String input) {
            try {
                return BaseJsonEncoder.getEncoder().fromJson(input, this.type);
            }
            catch (JSONException e) {
                if (!input.startsWith("\"") && !input.endsWith("\"")) {
                    try {
                        return BaseJsonEncoder.getEncoder().fromJson("\"" + input + "\"", this.type);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
    }
}

