/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import gu.dtalk.BaseOption;
import gu.dtalk.CheckOption;
import gu.dtalk.OptionType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SwitchOption<E>
extends CheckOption<E> {
    @JSONField(serialize=false, deserialize=false)
    private final Predicate<Set<Integer>> switchValidator = new Predicate<Set<Integer>>(){

        @Override
        public boolean apply(Set<Integer> input) {
            return input.size() == 1;
        }
    };

    public SwitchOption() {
        super.setValidator(this.switchValidator);
    }

    @Override
    public final OptionType getType() {
        return OptionType.SWITCH;
    }

    @Override
    public BaseOption<Set<Integer>> setValidator(Predicate<Set<Integer>> validator) {
        return super.setValidator(Predicates.and(this.switchValidator, validator));
    }

    @JSONField(serialize=false, deserialize=false)
    public E getSwitch() {
        List list = this.getSelected();
        return list.size() > 0 ? (E)list.get(0) : null;
    }

    @JSONField(serialize=false, deserialize=false)
    public CheckOption<E> setSwitch(E value) {
        return this.setSelected(Arrays.asList(value));
    }

    @Override
    @JSONField(serialize=false, deserialize=false)
    public CheckOption<E> setSelected(List<E> sel) {
        if (!(sel = MoreObjects.firstNonNull(sel, Collections.emptyList())).isEmpty()) {
            Preconditions.checkArgument(sel.size() == 1, "TOO MANY SELECTED OPTIONS");
        }
        return super.setSelected(sel);
    }
}

