/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.exception;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.dtalk.Ack;
import gu.dtalk.exception.CmdExecutionException;

public class InteractiveCmdStartException
extends CmdExecutionException {
    private static final long serialVersionUID = 1L;
    private final Ack.Status status;
    private final String statusMessage;

    public InteractiveCmdStartException(Ack.Status status) {
        this(status, null);
    }

    public InteractiveCmdStartException(Ack.Status status, String statusMessage) {
        this(status, statusMessage, null);
    }

    public InteractiveCmdStartException(Ack.Status status, String statusMessage, Throwable cause) {
        super(cause);
        Preconditions.checkArgument(status == Ack.Status.REJECTED || status == Ack.Status.UNSUPPORTED || status == Ack.Status.ERROR, "INVALID status, available value:%s,%s,%s", (Object)Ack.Status.REJECTED.name(), (Object)Ack.Status.UNSUPPORTED.name(), (Object)Ack.Status.ERROR.name());
        this.status = status;
        this.statusMessage = statusMessage;
    }

    @Override
    public String getMessage() {
        String expMsg;
        StringBuffer buffer = new StringBuffer();
        if (!Strings.isNullOrEmpty(this.statusMessage)) {
            buffer.append(this.statusMessage);
        }
        if ((expMsg = super.getMessage()) != null) {
            buffer.append(":").append(expMsg);
        }
        if (buffer.length() == 0) {
            buffer.append(this.status.name());
        }
        return buffer.toString();
    }

    public Ack.Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }
}

