/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import gu.simplemq.Constant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractConsumer
implements AutoCloseable,
Constant {
    private boolean daemon = false;
    protected int timeoutMills = 2000;
    private State state = State.INIT;
    protected boolean isFifo = true;
    private ExecutorService executorService;
    private final Runnable customeLoop = new Runnable(){

        @Override
        public void run() {
            Runnable customRun = AbstractConsumer.this.getCustomRunnable();
            while (AbstractConsumer.this.isOpened()) {
                try {
                    if (null == customRun) continue;
                    customRun.run();
                }
                catch (Exception e) {
                    Constant.logger.error(e.getMessage());
                }
            }
            AbstractConsumer.this.reset();
        }
    };

    protected abstract Runnable getCustomRunnable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() {
        try {
            AbstractConsumer abstractConsumer;
            if (this.state == State.OPENED) {
                return;
            }
            if (this.state == State.CLOSED) {
                abstractConsumer = this;
                synchronized (abstractConsumer) {
                    while (this.state != State.INIT) {
                        this.wait();
                    }
                }
            }
            abstractConsumer = this;
            synchronized (abstractConsumer) {
                while (this.state != State.INIT) {
                    if (this.state == State.OPENED) {
                        return;
                    }
                    if (this.state != State.CLOSED) continue;
                    this.wait();
                }
                this.state = State.OPENED;
                if (null != this.executorService) {
                    try {
                        this.executorService.execute(this.customeLoop);
                        return;
                    }
                    catch (RejectedExecutionException e) {
                        this.executorService = null;
                        logger.warn("RejectedExecutionException: {}", (Object)e.getMessage());
                    }
                }
                Thread thread = new Thread(this.customeLoop);
                thread.setDaemon(this.daemon);
                thread.start();
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractConsumer abstractConsumer = this;
        synchronized (abstractConsumer) {
            if (this.state == State.OPENED) {
                this.state = State.CLOSED;
            }
        }
    }

    private boolean isOpened() {
        return this.state == State.OPENED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        AbstractConsumer abstractConsumer = this;
        synchronized (abstractConsumer) {
            this.state = State.INIT;
            this.notifyAll();
        }
    }

    public AbstractConsumer setTimeoutMills(int timeoutMills) {
        if (timeoutMills > 0) {
            this.timeoutMills = timeoutMills;
        }
        return this;
    }

    public AbstractConsumer setFifo(boolean fifo) {
        this.isFifo = fifo;
        return this;
    }

    public AbstractConsumer setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public AbstractConsumer setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    private static enum State {
        INIT,
        OPENED,
        CLOSED;

    }
}

