/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.simplemq.Channel;
import gu.simplemq.Constant;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.IMessageDispatcher;
import gu.simplemq.IMessageRegister;
import gu.simplemq.IUnregistedListener;
import gu.simplemq.exceptions.SmqTypeException;
import gu.simplemq.exceptions.SmqUnsubscribeException;
import gu.simplemq.json.BaseJsonEncoder;
import gu.simplemq.utils.CommonUtils;
import gu.simplemq.utils.Synchronizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ChannelDispatcher
implements IMessageDispatcher,
IMessageRegister,
Constant {
    private BaseJsonEncoder encoder = BaseJsonEncoder.getEncoder();
    protected final LinkedHashMap<String, Channel<?>> channelSubs = new LinkedHashMap();
    private final Set<String> subChannelSet = new LinkedHashSet<String>();
    private final Synchronizer sync = new Synchronizer.ReadWriteSynchronizer();
    private volatile ExecutorService executor;
    private volatile ScheduledExecutorService timerExecutor;

    public ChannelDispatcher() {
    }

    public ChannelDispatcher(Channel<?> ... channels) {
        this.register(channels);
    }

    public ChannelDispatcher(Collection<Channel<?>> channels) {
        this(null == channels ? null : channels.toArray(new Channel[0]));
    }

    public String[] registedOnly(String ... channels) {
        return this.registedOnlyAsSet(channels).toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> registedOnlyAsSet(String ... channels) {
        this.sync.beginRead();
        try {
            HashSet<String> chSet = new HashSet<String>(CommonUtils.cleanEmptyAsList(channels));
            if (!chSet.isEmpty()) {
                chSet.retainAll(this.channelSubs.keySet());
            }
            HashSet<String> hashSet = chSet;
            return hashSet;
        }
        finally {
            this.sync.endRead();
        }
    }

    protected String check(String name) throws SmqTypeException {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Channel<?>> register(Channel<?> ... channels) {
        this.sync.beginWrite();
        try {
            HashSet chSet = new HashSet(CommonUtils.cleanNullAsList(channels));
            for (Channel<?> ch : chSet) {
                this.channelSubs.put(this.check(ch.name), ch);
            }
            this.subscribe(Channel.getChannelNames(chSet).toArray(new String[0]));
            HashSet hashSet = chSet;
            return hashSet;
        }
        finally {
            this.sync.endWrite();
        }
    }

    public <T> void register(final Channel<T> channel, long duration, TimeUnit unit) {
        this.register(Preconditions.checkNotNull(channel, "channel is null"));
        if (duration > 0L) {
            Preconditions.checkArgument(null != unit, "unit is null");
            final ScheduledFuture<?> timeUnregisterTask = this.getTimerExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    Constant.logger.debug("unregister channel '{}' caused by timeout", (Object)channel.name);
                    ChannelDispatcher.this.unregister(channel.name);
                }
            }, duration, unit);
            channel.addUnregistedListener(new IUnregistedListener<T>(){

                @Override
                public void apply(Channel<T> channel) {
                    if (!timeUnregisterTask.isDone() && timeUnregisterTask.getDelay(TimeUnit.MILLISECONDS) > 0L) {
                        timeUnregisterTask.cancel(false);
                        Constant.logger.debug("time task cancelled");
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> unregister(String ... channels) {
        this.sync.beginWrite();
        try {
            HashSet<String> chSet = new HashSet<String>(CommonUtils.cleanEmptyAsList(channels));
            if (!chSet.isEmpty()) {
                this.unsubscribe(chSet.toArray(new String[0]));
                for (String ch : chSet) {
                    Channel<?> channel = this.channelSubs.get(ch);
                    if (null == channel) continue;
                    this.channelSubs.remove(ch);
                    channel.onUnregisted();
                }
            }
            HashSet<String> hashSet = chSet;
            return hashSet;
        }
        finally {
            this.sync.endWrite();
        }
    }

    public Set<String> unregister(Channel ... channels) {
        return this.unregister(Channel.getChannelNames(channels));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> unregister(final IMessageAdapter<?> messageAdapter) {
        this.sync.beginWrite();
        try {
            String[] chSet = Maps.filterValues(this.channelSubs, new Predicate<Channel<?>>(){

                @Override
                public boolean apply(Channel<?> input) {
                    return input.getAdapter() == messageAdapter;
                }
            }).keySet().toArray(new String[0]);
            Set<String> set = this.unregister(chSet);
            return set;
        }
        finally {
            this.sync.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel getChannel(String channel) {
        this.sync.beginRead();
        try {
            Channel<?> channel2 = this.channelSubs.get(channel);
            return channel2;
        }
        finally {
            this.sync.endRead();
        }
    }

    @Override
    public void dispatch(String channel, final String message) {
        final Channel ch = this.getChannel(channel);
        if (null != ch) {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object deserialized = ChannelDispatcher.this.encoder.fromJson(message, ch.type);
                        ch.onSubscribe(deserialized);
                    }
                    catch (SmqUnsubscribeException e) {
                        if (e.unregister) {
                            ChannelDispatcher.this.unregister(ch.name);
                        } else {
                            ChannelDispatcher.this.unsubscribe(ch.name);
                        }
                        Constant.logger.info("unsubscribe channel: {}", (Object)ch.name);
                    }
                }
            });
        } else {
            logger.warn("unregistered channel: '{}'", (Object)channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] subscribe(String ... channels) {
        this.sync.beginWrite();
        try {
            channels = null == channels || 0 == channels.length ? this.channelSubs.keySet().toArray(new String[0]) : this.registedOnly(channels);
            this.subChannelSet.addAll(Arrays.asList(channels));
            String[] stringArray = channels;
            return stringArray;
        }
        finally {
            this.sync.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] unsubscribe(String ... channels) {
        this.sync.beginWrite();
        try {
            if (null == channels || 0 == channels.length) {
                channels = this.getSubscribes();
                this.subChannelSet.clear();
            } else {
                HashSet<String> chSet = this.registedOnlyAsSet(channels);
                this.subChannelSet.removeAll(chSet);
                channels = chSet.toArray(new String[0]);
            }
            String[] stringArray = channels;
            return stringArray;
        }
        finally {
            this.sync.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSubscribes() {
        this.sync.beginRead();
        try {
            String[] stringArray = this.subChannelSet.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.sync.endRead();
        }
    }

    public ChannelDispatcher setExecutor(ExecutorService executor) {
        this.executor = Preconditions.checkNotNull(executor, "executor is null");
        return this;
    }

    public ChannelDispatcher setTimerExecutor(ScheduledExecutorService timerExecutor) {
        this.timerExecutor = Preconditions.checkNotNull(timerExecutor, "timerExecutor is null");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutor() {
        if (this.executor == null) {
            ChannelDispatcher channelDispatcher = this;
            synchronized (channelDispatcher) {
                if (this.executor == null) {
                    this.executor = SingletonExecutor.DEFAULT_EXECUTOR;
                }
            }
        }
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledExecutorService getTimerExecutor() {
        if (this.timerExecutor == null) {
            ChannelDispatcher channelDispatcher = this;
            synchronized (channelDispatcher) {
                if (this.timerExecutor == null) {
                    this.timerExecutor = SingletonTimerExecutor.DEFAULT_TIMEREXECUTOR;
                }
            }
        }
        return this.timerExecutor;
    }

    public Map<String, Channel<?>> allRegisteredChannels() {
        return Maps.newHashMap(this.channelSubs);
    }

    private static class SingletonTimerExecutor {
        private static final ScheduledExecutorService DEFAULT_TIMEREXECUTOR = MoreExecutors.getExitingScheduledExecutorService(new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("channel-dispatcher-timer-%d").build()));

        private SingletonTimerExecutor() {
        }
    }

    private static class SingletonExecutor {
        private static final ExecutorService DEFAULT_EXECUTOR = MoreExecutors.getExitingExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("channel-dispatcher-%d").build()));

        private SingletonExecutor() {
        }
    }
}

