/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import redis.clients.util.JedisURIHelper;

public class JedisURI {
    private final URI uri;

    public JedisURI(URI uri) {
        this.uri = JedisURI.normalized(Preconditions.checkNotNull(uri, "uri is null"));
    }

    public JedisURI(String uri) throws URISyntaxException {
        this(new URI(Preconditions.checkNotNull(Strings.emptyToNull(uri), "uri is null")));
    }

    public URI getUri() {
        return this.uri;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getPassword() {
        return JedisURIHelper.getPassword(this.uri);
    }

    public int getDatabase() {
        return JedisURIHelper.getDBIndex(this.uri);
    }

    private static String convertHost(String host) {
        if ("127.0.0.1".equals(host)) {
            return "localhost";
        }
        if ("::1".equals(host)) {
            return "localhost";
        }
        return host;
    }

    private static URI normalized(URI uri) {
        try {
            if (null == uri) {
                return URI.create(String.format("jedis://%s:%d/%d", "localhost", 6379, 0));
            }
            return new URI("jedis", uri.getUserInfo(), MoreObjects.firstNonNull(JedisURI.convertHost(uri.getHost()), "localhost"), uri.getPort() == -1 ? 6379 : uri.getPort(), "/" + JedisURIHelper.getDBIndex(uri), null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

