/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.JedisURI;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.JedisURIHelper;

public class JedisUtils {
    private JedisUtils() {
    }

    public static HashMap<JedisPoolLazy.PropName, Object> initParameters(Map<JedisPoolLazy.PropName, Object> props) {
        HashMap<JedisPoolLazy.PropName, Object> params = Maps.newHashMap(JedisPoolLazy.DEFAULT_PARAMETERS);
        if (null != props) {
            Map<JedisPoolLazy.PropName, Object> filtered = Maps.filterValues(props, Predicates.notNull());
            params.putAll(filtered);
            URI uri = (URI)props.get((Object)JedisPoolLazy.PropName.uri);
            if (uri != null) {
                String pwd;
                int dbIndex;
                uri = new JedisURI(uri).getUri();
                params.put(JedisPoolLazy.PropName.uri, uri);
                if (uri.getHost() != null) {
                    params.put(JedisPoolLazy.PropName.host, uri.getHost());
                }
                if (uri.getPort() != -1) {
                    params.put(JedisPoolLazy.PropName.port, uri.getPort());
                }
                if ((dbIndex = JedisURIHelper.getDBIndex(uri)) != 0) {
                    params.put(JedisPoolLazy.PropName.database, dbIndex);
                }
                if ((pwd = JedisURIHelper.getPassword(uri)) != null) {
                    params.put(JedisPoolLazy.PropName.password, pwd);
                }
            }
        }
        return params;
    }

    public static URI createJedisURI(String scheme, String host, Integer port, String password, Integer database) {
        String userInfo = null;
        if (!Strings.isNullOrEmpty(password)) {
            userInfo = ":" + password;
        }
        try {
            return new URI(MoreObjects.firstNonNull(scheme, "jedis"), userInfo, MoreObjects.firstNonNull(host, "localhost"), MoreObjects.firstNonNull(port, 6379), "/" + MoreObjects.firstNonNull(database, 0), null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI createJedisURI(String host, Integer port, String password, Integer database) {
        return JedisUtils.createJedisURI("jedis", host, port, password, database);
    }

    public static URI getCanonicalURI(Map<JedisPoolLazy.PropName, Object> parameters) {
        URI uri = (URI)(parameters = JedisUtils.initParameters(parameters)).get((Object)JedisPoolLazy.PropName.uri);
        uri = null == uri ? JedisUtils.createJedisURI((String)parameters.get((Object)JedisPoolLazy.PropName.host), ((Number)parameters.get((Object)JedisPoolLazy.PropName.port)).intValue(), (String)parameters.get((Object)JedisPoolLazy.PropName.password), ((Number)parameters.get((Object)JedisPoolLazy.PropName.database)).intValue()) : new JedisURI(uri).getUri();
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runOnRedis(Function<Jedis, T> fun, JedisPoolLazy poolLazy) {
        if (null == fun) {
            return null;
        }
        Jedis jedis = poolLazy.apply();
        try {
            T t = fun.apply(jedis);
            return t;
        }
        finally {
            poolLazy.free();
        }
    }

    public static <T> T runOnRedis(Function<Jedis, T> fun) {
        return JedisUtils.runOnRedis(fun, JedisPoolLazy.getDefaultInstance());
    }

    public static String set(JedisPoolLazy jedisPoolLazy, final String key, final String value) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key) && !Strings.isNullOrEmpty(value), "key or value is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, String>(){

            @Override
            public String apply(Jedis input) {
                input.set(key, value);
                return input.get(key);
            }
        }, jedisPoolLazy);
    }

    public static String set(String key, String value) {
        return JedisUtils.set(JedisPoolLazy.getDefaultInstance(), key, value);
    }

    public static String setnx(JedisPoolLazy jedisPoolLazy, final String key, final String value) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key) && !Strings.isNullOrEmpty(value), "key or value is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, String>(){

            @Override
            public String apply(Jedis input) {
                input.setnx(key, value);
                return input.get(key);
            }
        }, jedisPoolLazy);
    }

    public static String setnx(String key, String value) {
        return JedisUtils.setnx(JedisPoolLazy.getDefaultInstance(), key, value);
    }

    public static int pubsubNumSub(JedisPoolLazy jedisPoolLazy, final String channel) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(channel), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, Integer>(){

            @Override
            public Integer apply(Jedis input) {
                return Integer.parseInt(input.pubsubNumSub(channel).get(channel));
            }
        }, jedisPoolLazy);
    }

    public static int pubsubNumSub(String channel) {
        return JedisUtils.pubsubNumSub(JedisPoolLazy.getDefaultInstance(), channel);
    }

    public static String get(JedisPoolLazy jedisPoolLazy, final String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, String>(){

            @Override
            public String apply(Jedis input) {
                return input.get(key);
            }
        }, jedisPoolLazy);
    }

    public static String get(String key) {
        return JedisUtils.get(JedisPoolLazy.getDefaultInstance(), key);
    }

    public static Set<String> keys(JedisPoolLazy jedisPoolLazy, final String pattern) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(pattern), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, Set<String>>(){

            @Override
            public Set<String> apply(Jedis input) {
                return input.keys(pattern);
            }
        }, jedisPoolLazy);
    }

    public static Set<String> keys(String pattern) {
        return JedisUtils.keys(JedisPoolLazy.getDefaultInstance(), pattern);
    }

    public static int del(JedisPoolLazy jedisPoolLazy, final String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, Long>(){

            @Override
            public Long apply(Jedis input) {
                return input.del(key);
            }
        }, jedisPoolLazy).intValue();
    }

    public static int del(String key) {
        return JedisUtils.del(JedisPoolLazy.getDefaultInstance(), key);
    }

    public static int incr(JedisPoolLazy jedisPoolLazy, final String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, Integer>(){

            @Override
            public Integer apply(Jedis input) {
                return input.incr(key).intValue();
            }
        }, jedisPoolLazy);
    }

    public static int incr(String key) {
        return JedisUtils.incr(JedisPoolLazy.getDefaultInstance(), key);
    }

    public static int decr(JedisPoolLazy jedisPoolLazy, final String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, Integer>(){

            @Override
            public Integer apply(Jedis input) {
                return input.decr(key).intValue();
            }
        }, jedisPoolLazy);
    }

    public static int decr(String key) {
        return JedisUtils.decr(JedisPoolLazy.getDefaultInstance(), key);
    }

    public static int sadd(JedisPoolLazy jedisPoolLazy, final String key, final String ... members) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        Preconditions.checkArgument(members != null, "members is null ");
        return JedisUtils.runOnRedis(new Function<Jedis, Integer>(){

            @Override
            public Integer apply(Jedis input) {
                return input.sadd(key, members).intValue();
            }
        }, jedisPoolLazy);
    }

    public static int sadd(String key, String ... members) {
        return JedisUtils.sadd(JedisPoolLazy.getDefaultInstance(), key, members);
    }

    public static int srem(JedisPoolLazy jedisPoolLazy, final String key, final String ... members) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        Preconditions.checkArgument(members != null, "members is null ");
        return JedisUtils.runOnRedis(new Function<Jedis, Integer>(){

            @Override
            public Integer apply(Jedis input) {
                return input.srem(key, members).intValue();
            }
        }, jedisPoolLazy);
    }

    public static int srem(String key, String ... members) {
        return JedisUtils.srem(JedisPoolLazy.getDefaultInstance(), key, members);
    }

    public static int scard(JedisPoolLazy jedisPoolLazy, final String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, Integer>(){

            @Override
            public Integer apply(Jedis input) {
                return input.scard(key).intValue();
            }
        });
    }

    public static int scard(String key) {
        return JedisUtils.scard(JedisPoolLazy.getDefaultInstance(), key);
    }

    public static boolean expire(JedisPoolLazy jedisPoolLazy, final String key, final long timeMills, final boolean timestamp) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return JedisUtils.runOnRedis(new Function<Jedis, Boolean>(){

            @Override
            public Boolean apply(Jedis input) {
                if (timestamp) {
                    return 1L == input.pexpireAt(key, timeMills);
                }
                return 1L == input.pexpire(key, timeMills);
            }
        }, jedisPoolLazy);
    }

    public static boolean expire(String key, long timeMills, boolean timestamp) {
        return JedisUtils.expire(JedisPoolLazy.getDefaultInstance(), key, timeMills, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkConnect(Map<JedisPoolLazy.PropName, Object> input) {
        HashMap<JedisPoolLazy.PropName, Object> props = JedisUtils.initParameters(input);
        try (Jedis jedis = new Jedis((String)props.get((Object)JedisPoolLazy.PropName.host), ((Number)props.get((Object)JedisPoolLazy.PropName.port)).intValue(), ((Number)props.get((Object)JedisPoolLazy.PropName.timeout)).intValue(), ((Number)props.get((Object)JedisPoolLazy.PropName.timeout)).intValue());){
            int database;
            jedis.connect();
            String password = (String)props.get((Object)JedisPoolLazy.PropName.password);
            if (!Strings.isNullOrEmpty(password)) {
                jedis.auth(password);
            }
            if ((database = ((Integer)props.get((Object)JedisPoolLazy.PropName.database)).intValue()) != 0) {
                jedis.select(database);
            }
        }
    }

    public static boolean testConnect(Map<JedisPoolLazy.PropName, Object> props) {
        try {
            JedisUtils.checkConnect(props);
            return true;
        }
        catch (JedisException je) {
            return false;
        }
    }

    public static boolean testConnect(Jedis jedis) {
        return jedis instanceof Jedis && jedis.isConnected() && jedis.ping().equals("PONG");
    }
}

