/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Strings;
import gu.simplemq.AbstractConsumer;
import gu.simplemq.Channel;
import gu.simplemq.ChannelDispatcher;
import gu.simplemq.Constant;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.IMessageRegister;
import gu.simplemq.exceptions.SmqTypeException;
import gu.simplemq.redis.IRedisComponent;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.JedisUtils;
import gu.simplemq.redis.RedisComponentType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.Jedis;

public class RedisConsumer
extends AbstractConsumer
implements IRedisComponent,
IMessageRegister {
    private static final String consumerSetSuffix = "_consumers";
    public static final String CONSUMER_COUNTER = "simplemq_consumer_counter";
    private final JedisPoolLazy poolLazy;
    private final ChannelDispatcher register = new ChannelDispatcher(){

        @Override
        protected String check(String name) throws SmqTypeException {
            return RedisComponentType.Queue.check(RedisConsumer.this.poolLazy, name);
        }
    };
    private int timeout;
    private final String consumerId;
    private final Runnable customRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                List<String> list;
                Jedis jedis = RedisConsumer.this.poolLazy.apply();
                try {
                    String[] keys = RedisConsumer.this.register.getSubscribes();
                    if (0 == keys.length) {
                        RedisConsumer.this.close();
                        return;
                    }
                    list = RedisConsumer.this.isFifo ? jedis.blpop(RedisConsumer.this.timeout, keys) : jedis.brpop(RedisConsumer.this.timeout, keys);
                }
                finally {
                    RedisConsumer.this.poolLazy.free();
                }
                if (!list.isEmpty()) {
                    String channel = list.get(0);
                    String message = list.get(1);
                    RedisConsumer.this.register.dispatch(channel, message);
                }
            }
            catch (Exception e) {
                Constant.logger.error(e.getMessage());
            }
        }
    };

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.poolLazy;
    }

    RedisConsumer(JedisPoolLazy poolLazy) {
        this.poolLazy = poolLazy;
        this.setTimeoutMills(2000);
        this.consumerId = "RedisConsumer_" + JedisUtils.incr(poolLazy, CONSUMER_COUNTER);
    }

    @Override
    protected Runnable getCustomRunnable() {
        return this.customRunnable;
    }

    private void addConsumer(Collection<String> chSet) {
        for (String name : chSet) {
            JedisUtils.sadd(name + consumerSetSuffix, this.consumerId);
        }
    }

    private void addConsumer(String[] chSet) {
        this.addConsumer(Arrays.asList(chSet));
    }

    private void removeConsumer(Collection<String> chSet) {
        for (String name : chSet) {
            JedisUtils.srem(name + consumerSetSuffix, this.consumerId);
        }
    }

    private void removeConsumer(String[] chSet) {
        this.removeConsumer(Arrays.asList(chSet));
    }

    @Override
    public Set<Channel<?>> register(Channel<?> ... channels) {
        Set<Channel<?>> chSet = this.register.register(channels);
        this.open();
        this.addConsumer(Channel.getChannelNames(chSet));
        return chSet;
    }

    @Override
    public Set<String> unregister(String ... channels) {
        Set<String> chSet = this.register.unregister(channels);
        this.removeConsumer(chSet);
        return chSet;
    }

    @Override
    public Set<String> unregister(Channel<?> ... channels) {
        Set<String> chSet = this.register.unregister((Channel[])channels);
        this.removeConsumer(chSet);
        return chSet;
    }

    @Override
    public Set<String> unregister(IMessageAdapter<?> messageAdapter) {
        Set<String> chSet = this.register.unregister(messageAdapter);
        this.removeConsumer(chSet);
        return chSet;
    }

    @Override
    public String[] subscribe(String ... channels) {
        channels = this.register.subscribe(channels);
        this.open();
        this.addConsumer(channels);
        return channels;
    }

    @Override
    public String[] unsubscribe(String ... channels) {
        String[] chSet = this.register.unsubscribe(channels);
        this.removeConsumer(chSet);
        return chSet;
    }

    @Override
    public Channel getChannel(String channel) {
        return this.register.getChannel(channel);
    }

    @Override
    public String[] getSubscribes() {
        return this.register.getSubscribes();
    }

    @Override
    public AbstractConsumer setTimeoutMills(int timeoutMills) {
        super.setTimeoutMills(timeoutMills);
        this.timeout = (int)TimeUnit.SECONDS.convert(this.timeoutMills, TimeUnit.MILLISECONDS);
        return this;
    }

    public RedisConsumer setTimeout(int timeout) {
        if (timeout > 0) {
            this.timeout = timeout;
            super.setTimeoutMills((int)TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.SECONDS));
        }
        return this;
    }

    @Override
    public void close() {
        super.close();
        this.unsubscribe(new String[0]);
    }

    public static int countOf(String channel) {
        if (Strings.isNullOrEmpty(channel)) {
            return 0;
        }
        return JedisUtils.scard(channel + consumerSetSuffix);
    }
}

