/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import gu.simplemq.Channel;
import gu.simplemq.Constant;
import gu.simplemq.exceptions.SmqException;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisConsumer;
import gu.simplemq.redis.RedisProducer;
import gu.simplemq.redis.RedisPublisher;
import gu.simplemq.redis.RedisSubscriber;
import gu.simplemq.redis.RedisTable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;

public class RedisFactory
implements Constant {
    private static final Table<JedisPoolLazy, String, RedisTable> TABLE = HashBasedTable.create();
    private static final RedisInstance<RedisConsumer> CONSUMERS = new RedisInstance<RedisConsumer>(RedisConsumer.class){

        @Override
        void beforeDelete(RedisConsumer r) {
            r.close();
        }
    };
    private static final RedisInstance<RedisSubscriber> SUBSCRIBERS = new RedisInstance<RedisSubscriber>(RedisSubscriber.class){

        @Override
        protected void beforeDelete(RedisSubscriber r) {
            r.close();
        }
    };
    private static final RedisInstance<RedisProducer> PRODUCERS = new RedisInstance<RedisProducer>(RedisProducer.class);
    private static final RedisInstance<RedisPublisher> PUBLISHERS = new RedisInstance<RedisPublisher>(RedisPublisher.class);

    private RedisFactory() {
    }

    public static <V> RedisTable<V> getTable(Class<V> clazz) {
        return RedisFactory.getTable(clazz, JedisPoolLazy.getDefaultInstance(), Preconditions.checkNotNull(clazz, "clazz is null").getSimpleName());
    }

    public static <V> RedisTable<V> getTable(Class<V> clazz, JedisPoolLazy pool, String tablename) {
        return RedisFactory.getTable(clazz, pool, tablename);
    }

    public static <V> RedisTable<V> getTable(Channel<V> channel, JedisPoolLazy pool) {
        return RedisFactory.getTable(channel.type, pool, channel.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> RedisTable<V> getTable(Type type, JedisPoolLazy pool, String tablename) {
        Preconditions.checkArgument(null != type && null != pool && null != tablename, "input aruments must not be null");
        if (!TABLE.contains(pool, tablename)) {
            Table<JedisPoolLazy, String, RedisTable> table = TABLE;
            synchronized (table) {
                if (!TABLE.contains(pool, tablename)) {
                    RedisTable previous = TABLE.put(pool, tablename, new RedisTable(type, pool, tablename));
                }
            }
        }
        RedisTable table = TABLE.get(pool, tablename);
        Preconditions.checkState(table.getType().equals(type), "mismatch type " + type + " vs " + table.getType());
        return table;
    }

    public static void clearConsumers() {
        CONSUMERS.clearInstances();
    }

    public static RedisConsumer getConsumer(JedisPoolLazy jedisPoolLazy) {
        return CONSUMERS.getInstance(jedisPoolLazy);
    }

    public static RedisConsumer getConsumer() {
        return CONSUMERS.getInstance(JedisPoolLazy.getDefaultInstance());
    }

    public static void clearSubscribers() {
        SUBSCRIBERS.clearInstances();
    }

    public static RedisSubscriber getSubscriber(JedisPoolLazy jedisPoolLazy) {
        return SUBSCRIBERS.getInstance(jedisPoolLazy);
    }

    public static RedisSubscriber getSubscriber() {
        return SUBSCRIBERS.getInstance(JedisPoolLazy.getDefaultInstance());
    }

    public static RedisProducer getProducer(JedisPoolLazy jedisPoolLazy) {
        return PRODUCERS.getInstance(jedisPoolLazy);
    }

    public static RedisProducer getProducer() {
        return PRODUCERS.getInstance(JedisPoolLazy.getDefaultInstance());
    }

    public static RedisPublisher getPublisher(JedisPoolLazy jedisPoolLazy) {
        return PUBLISHERS.getInstance(jedisPoolLazy);
    }

    public static RedisPublisher getPublisher() {
        return PUBLISHERS.getInstance(JedisPoolLazy.getDefaultInstance());
    }

    public static synchronized void closeAll() {
        RedisFactory.clearConsumers();
        RedisFactory.clearSubscribers();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    RedisFactory.closeAll();
                }
                catch (Exception e) {
                    Constant.logger.error(e.getMessage(), e);
                }
            }
        });
    }

    private static class RedisInstance<R> {
        private final LoadingCache<JedisPoolLazy, R> cache = CacheBuilder.newBuilder().build(new CacheLoader<JedisPoolLazy, R>(){

            @Override
            public R load(JedisPoolLazy key) throws Exception {
                return RedisInstance.this.constructor.newInstance(key);
            }
        });
        private final Constructor<R> constructor;

        public RedisInstance(Class<R> clazz) {
            try {
                this.constructor = clazz.getDeclaredConstructor(JedisPoolLazy.class);
            }
            catch (Exception e) {
                throw new SmqException(e);
            }
        }

        void beforeDelete(R r) {
        }

        synchronized void clearInstances() {
            for (Object r : this.cache.asMap().values()) {
                this.beforeDelete(r);
                try {
                    if (!(r instanceof AutoCloseable)) continue;
                    ((AutoCloseable)r).close();
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked(e);
                    throw new RuntimeException(e);
                }
            }
            this.cache.asMap().clear();
        }

        R getInstance(JedisPoolLazy jedisPoolLazy) {
            return this.cache.getUnchecked(jedisPoolLazy);
        }
    }
}

