/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import gu.simplemq.KeyExpire;
import gu.simplemq.redis.JedisPoolLazy;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.Jedis;

class RedisKeyExpire
extends KeyExpire {
    private final JedisPoolLazy poolLazy;

    public RedisKeyExpire(JedisPoolLazy poolLazy) {
        this.poolLazy = poolLazy;
    }

    public static void expire(Jedis jedis, String key, long timeMills, boolean timestamp) {
        if (timestamp) {
            jedis.pexpireAt(key, timeMills);
        } else {
            jedis.pexpire(key, timeMills);
        }
    }

    public static void expire(Jedis jedis, String key, long time, TimeUnit timeUnit) {
        RedisKeyExpire.expire(jedis, key, TimeUnit.MILLISECONDS.convert(time, timeUnit), true);
    }

    public static void expire(Jedis jedis, String key, Date date) {
        RedisKeyExpire.expire(jedis, key, date.getTime(), true);
    }

    protected final void expire(Jedis jedis, String key) {
        RedisKeyExpire.expire(jedis, this.wrapKey(key), this.timeMills, this.timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doExpire(String key, long timeMills, boolean timestamp) {
        Jedis jedis = this.poolLazy.apply();
        try {
            RedisKeyExpire.expire(jedis, this.wrapKey(key), timeMills, timestamp);
        }
        finally {
            this.poolLazy.free();
        }
    }

    protected String wrapKey(String key) {
        return key;
    }
}

