/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import gu.simplemq.Channel;
import gu.simplemq.IPublisher;
import gu.simplemq.json.BaseJsonEncoder;
import gu.simplemq.redis.IRedisComponent;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.utils.CommonUtils;
import java.util.Collection;
import redis.clients.jedis.Jedis;

public class RedisPublisher
implements IPublisher,
IRedisComponent {
    private BaseJsonEncoder encoder = BaseJsonEncoder.getEncoder();
    private final JedisPoolLazy poolLazy;

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.poolLazy;
    }

    public RedisPublisher(JedisPoolLazy poolLazy) {
        this.poolLazy = poolLazy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> long publish(Channel<T> channel, T obj) {
        if (null == obj) {
            return 0L;
        }
        if (null != channel.type && channel.type instanceof Class && !((Class)channel.type).isInstance(obj)) {
            throw new IllegalArgumentException("invalid type of 'obj'");
        }
        Jedis jedis = this.poolLazy.apply();
        try {
            Long numOfClient = jedis.publish(channel.name, this.encoder.toJsonString(obj));
            long l = null == numOfClient ? 0L : numOfClient;
            return l;
        }
        finally {
            this.poolLazy.free();
        }
    }

    @Override
    public <T> void publish(Channel<T> channel, Collection<T> objects) {
        objects = CommonUtils.cleanNullAsList(objects);
        for (T obj : objects) {
            this.publish(channel, obj);
        }
    }

    @Override
    public <T> void publish(Channel<T> channel, T ... objects) {
        this.publish(channel, (Collection<T>)CommonUtils.cleanNullAsList(objects));
    }
}

