/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.simplemq.AbstractSubcriber;
import gu.simplemq.Constant;
import gu.simplemq.IMessageDispatcher;
import gu.simplemq.exceptions.SmqTypeException;
import gu.simplemq.redis.IRedisComponent;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisComponentType;
import gu.simplemq.redis.RedisSubHandle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisSubscriber
extends AbstractSubcriber
implements IRedisComponent {
    private final JedisPoolLazy pool;
    private RedisSubHandle jedisPubSub = new RedisSubHandle(this);
    private static final int RECONNECT_DELAY_MILLS = 5000;
    private static final ExecutorService subscribeExecutor = MoreExecutors.getExitingExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("stp-subscribe-%d").build()));
    private volatile Jedis jedis = null;

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.pool;
    }

    RedisSubscriber(JedisPoolLazy poolLazy) {
        this.pool = poolLazy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSubscribe(String ... channels) {
        RedisSubscriber redisSubscriber = this;
        synchronized (redisSubscriber) {
            try {
                this.jedisPubSub.subscribe(channels);
            }
            catch (JedisConnectionException e) {
                this.open(channels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUnsubscribe(String ... channels) {
        RedisSubscriber redisSubscriber = this;
        synchronized (redisSubscriber) {
            if (this.jedisPubSub.isSubscribed()) {
                this.jedisPubSub.unsubscribe(channels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jedis getJedis() {
        if (null == this.jedis) {
            RedisSubscriber redisSubscriber = this;
            synchronized (redisSubscriber) {
                if (null == this.jedis) {
                    this.jedis = this.pool.getJedis();
                }
            }
        }
        return this.jedis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJedis() {
        if (this.jedis != null) {
            RedisSubscriber redisSubscriber = this;
            synchronized (redisSubscriber) {
                if (this.jedis != null) {
                    this.pool.releaseJedis(this.jedis);
                    this.jedis = null;
                }
            }
        }
    }

    private void open(final String ... channels) {
        Runnable run = new Runnable(){
            String[] subs;
            {
                this.subs = channels;
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        RedisSubscriber.this.getJedis().subscribe(RedisSubscriber.this.jedisPubSub, this.subs);
                    }
                    catch (JedisConnectionException e) {
                        RedisSubscriber.this.releaseJedis();
                        Constant.logger.error("Subscribing failed. {}", (Object)e.getMessage());
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.subs = RedisSubscriber.this.channelSubs.keySet().toArray(new String[0]);
                        continue;
                    }
                    catch (Exception e) {
                        Constant.logger.error("Subscribing failed.", e);
                        continue;
                    }
                    break;
                }
            }
        };
        subscribeExecutor.execute(run);
    }

    public RedisSubscriber setDispatcher(IMessageDispatcher dispatcher) {
        this.jedisPubSub.setDispatcher(dispatcher);
        return this;
    }

    @Override
    protected String check(String name) throws SmqTypeException {
        return RedisComponentType.Channel.check(this.pool, name);
    }

    @Override
    public void close() {
        super.close();
        this.releaseJedis();
    }
}

