/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.simplemq.AbstractTable;
import gu.simplemq.Channel;
import gu.simplemq.exceptions.SmqTableException;
import gu.simplemq.redis.IRedisComponent;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisComponentType;
import gu.simplemq.redis.RedisKeyExpire;
import gu.simplemq.redis.TablenameChecker;
import gu.simplemq.utils.CommonUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;

public class RedisTable<V>
extends AbstractTable<V>
implements IRedisComponent {
    private final JedisPoolLazy pool;
    private static final String PREFIX_END = ".";
    private final TablenameChecker checker;
    private final RedisKeyExpire redisExpire;
    private final String prefix;

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.pool;
    }

    public RedisTable(Class<V> clazz) {
        this(clazz, JedisPoolLazy.getDefaultInstance(), null);
    }

    public RedisTable(Class<V> clazz, JedisPoolLazy pool, String tablename) {
        this((Type)clazz, pool, tablename);
    }

    public RedisTable(Channel<V> channel, JedisPoolLazy pool) {
        this(channel.type, pool, channel.name);
    }

    public RedisTable(Type type, JedisPoolLazy pool, String tablename) {
        super(type);
        this.pool = Preconditions.checkNotNull(pool, "pool is null");
        this.checker = TablenameChecker.getNameChecker(pool);
        try {
            tablename = this.format(tablename);
        }
        catch (Exception e) {
            tablename = type instanceof Class ? this.format(((Class)type).getSimpleName()) : this.format(type.toString());
        }
        this.prefix = tablename;
        this.redisExpire = new RedisKeyExpire(this.pool){

            @Override
            protected String wrapKey(String key) {
                return RedisTable.this.wrapKey(key);
            }
        };
        this.keyExpire = this.redisExpire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V doGet(String key) {
        key = this.wrapKey(key);
        Jedis jedis = this.pool.apply();
        try {
            if (this.isJavaBean) {
                Object t = this.encoder.fromJson(jedis.hgetAll(key), this.getType());
                return (V)t;
            }
            Object t = this.encoder.fromJson(jedis.get(key), this.getType());
            return (V)t;
        }
        finally {
            this.pool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, V> get(String ... keys) {
        if (this.isJavaBean) {
            return super.get(keys);
        }
        String[] wkeys = CommonUtils.cleanEmpty(keys);
        for (int i = 0; i < keys.length; ++i) {
            wkeys[i] = this.wrapKey(wkeys[i]);
        }
        Jedis jedis = this.pool.apply();
        try {
            List<String> values = jedis.mget(wkeys);
            HashMap m = new HashMap(16);
            for (int i = 0; i < wkeys.length; ++i) {
                m.put(wkeys[i], this.encoder.fromJson(values.get(i), this.getType()));
            }
            HashMap hashMap = m;
            return hashMap;
        }
        finally {
            this.pool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSet(String key, V value, boolean nx) {
        key = this.wrapKey(key);
        Jedis jedis = this.pool.apply();
        try {
            if (nx) {
                jedis.setnx(key, this.encoder.toJsonString(value));
            } else {
                jedis.set(key, this.encoder.toJsonString(value));
            }
        }
        finally {
            this.pool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetFields(String key, Map<String, String> fieldsValues, boolean nx) {
        key = this.wrapKey(key);
        if (null == fieldsValues || fieldsValues.isEmpty()) {
            return;
        }
        Jedis jedis = this.pool.apply();
        try {
            List<Object> response;
            HashMap<String, String> hash = new HashMap<String, String>(16);
            ArrayList<String> nullFields = new ArrayList<String>(16);
            for (Map.Entry<String, String> entry : fieldsValues.entrySet()) {
                String value = entry.getValue();
                String field = entry.getKey();
                if (null == value) {
                    nullFields.add(field);
                    continue;
                }
                hash.put(field, value);
            }
            Transaction ctx = jedis.multi();
            if (!hash.isEmpty()) {
                if (nx) {
                    for (Map.Entry entry : hash.entrySet()) {
                        ctx.hsetnx(key, (String)entry.getKey(), (String)entry.getValue());
                    }
                } else {
                    ctx.hmset(key, hash);
                }
            }
            if (!nullFields.isEmpty() && !nx) {
                ctx.hdel(key, nullFields.toArray(new String[0]));
            }
            if ((response = ctx.exec()).isEmpty()) {
                throw new SmqTableException("Transaction error");
            }
        }
        finally {
            this.pool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetField(String key, String field, Object value, boolean nx) {
        key = this.wrapKey(key);
        Jedis jedis = this.pool.apply();
        try {
            if (null != value) {
                if (nx) {
                    jedis.hsetnx(key, field, this.encoder.toJsonString(value));
                } else {
                    jedis.hset(key, field, this.encoder.toJsonString(value));
                }
            } else if (!nx) {
                jedis.hdel(key, field);
            }
        }
        finally {
            this.pool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRemove(String ... keys) {
        Jedis jedis = this.pool.apply();
        try {
            String[] wkeys = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                wkeys[i] = this.wrapKey(keys[i]);
            }
            int n = jedis.del(wkeys).intValue();
            return n;
        }
        finally {
            this.pool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<String> doKeys(String pattern) {
        Jedis jedis = this.pool.apply();
        try {
            Set<String> keys = jedis.keys(this.wrapKey(pattern));
            for (String key : keys.toArray(new String[keys.size()])) {
                keys.remove(key);
                keys.add(this.unwrapKey(key));
            }
            Set<String> set = keys;
            return set;
        }
        finally {
            this.pool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetString(Map<String, V> m, boolean nx) {
        Jedis jedis = this.pool.apply();
        try {
            List<Object> response;
            ArrayList<String> keysValues = new ArrayList<String>(16);
            ArrayList<String> keysNull = new ArrayList<String>(16);
            for (Map.Entry<String, V> entry : m.entrySet()) {
                V value = entry.getValue();
                if (null != value) {
                    keysValues.add(this.wrapKey(entry.getKey()));
                    keysValues.add(this.encoder.toJsonString(value));
                    continue;
                }
                keysNull.add(this.wrapKey(entry.getKey()));
            }
            Transaction ctx = jedis.multi();
            if (!keysValues.isEmpty()) {
                if (nx) {
                    ctx.msetnx(keysValues.toArray(new String[0]));
                } else {
                    ctx.mset(keysValues.toArray(new String[0]));
                }
            }
            if (!keysNull.isEmpty() && !nx) {
                jedis.del(keysNull.toArray(new String[0]));
            }
            if ((response = ctx.exec()).isEmpty()) {
                throw new SmqTableException("Transaction error");
            }
        }
        finally {
            this.pool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetHash(Map<String, ? extends V> m, boolean nx) {
        Jedis jedis = this.pool.apply();
        try {
            List<Object> response;
            HashMap<String, Map<String, String>> keysValues = new HashMap<String, Map<String, String>>(16);
            ArrayList<String> keysNull = new ArrayList<String>(16);
            for (Map.Entry<String, V> entry : m.entrySet()) {
                V value = entry.getValue();
                if (null != value) {
                    keysValues.put(this.wrapKey(entry.getKey()), this.encoder.toJsonMap(value));
                    continue;
                }
                keysNull.add(this.wrapKey(entry.getKey()));
            }
            Transaction ctx = jedis.multi();
            if (!keysValues.isEmpty()) {
                if (nx) {
                    for (Map.Entry entry : keysValues.entrySet()) {
                        for (Map.Entry props : ((Map)entry.getValue()).entrySet()) {
                            ctx.hsetnx((String)entry.getKey(), (String)props.getValue(), (String)props.getValue());
                        }
                    }
                } else {
                    for (Map.Entry entry : keysValues.entrySet()) {
                        ctx.hmset((String)entry.getKey(), (Map)entry.getValue());
                    }
                }
            }
            if (!keysNull.isEmpty() && !nx) {
                jedis.del(keysNull.toArray(new String[0]));
            }
            if ((response = ctx.exec()).isEmpty()) {
                throw new SmqTableException("Transaction error");
            }
        }
        finally {
            this.pool.free();
        }
    }

    @Override
    protected void doSet(Map<String, V> m, boolean nx) {
        if (this.isJavaBean) {
            this.doSetHash(m, nx);
        } else {
            this.doSetString(m, nx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> doGetFields(String key, Map<String, Type> types) {
        key = this.wrapKey(key);
        Jedis jedis = this.pool.apply();
        try {
            Map<String, String> fieldHash;
            if (null == types || types.isEmpty()) {
                fieldHash = jedis.hgetAll(key);
            } else {
                String[] fields = types.keySet().toArray(new String[types.size()]);
                List<String> values = jedis.hmget(key, fields);
                fieldHash = new LinkedHashMap<String, String>();
                for (int i = 0; i < fields.length; ++i) {
                    fieldHash.put(fields[i], values.get(i));
                }
            }
            Map<String, Object> map = this.encoder.fromJson(fieldHash, types);
            return map;
        }
        finally {
            this.pool.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        if (Strings.isNullOrEmpty(key)) {
            return false;
        }
        key = this.wrapKey(key);
        Jedis jedis = this.pool.apply();
        try {
            boolean bl = jedis.exists(key);
            return bl;
        }
        finally {
            this.pool.free();
        }
    }

    @Override
    protected List<String> doGetFieldNames() {
        List<FieldInfo> fieldList = TypeUtils.computeGetters(TypeUtils.getRawClass(this.getType()), null);
        ArrayList<String> fields = new ArrayList<String>(fieldList.size());
        for (FieldInfo field : fieldList) {
            fields.add(field.name);
        }
        return fields;
    }

    public String getTableName() {
        return this.prefix;
    }

    private String format(String prefix) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(prefix), "prefix is null or empty");
        return this.checker.check(prefix.replaceAll("[\\s\\W]+", "_"), RedisComponentType.Table, this.getType());
    }

    private String wrapKey(String key) {
        return this.prefix + PREFIX_END + key;
    }

    private String unwrapKey(String key) {
        return key.substring(this.prefix.length() + PREFIX_END.length());
    }
}

