/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CommonUtils {
    private CommonUtils() {
    }

    public static final String[] cleanEmpty(String ... strings) {
        return CommonUtils.cleanEmptyAsList(strings).toArray(new String[0]);
    }

    public static final List<String> cleanEmptyAsList(String ... strings) {
        if (null == strings || 0 == strings.length) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(strings.length);
        for (String element : strings) {
            if (null == element || element.isEmpty()) continue;
            list.add(element);
        }
        return list;
    }

    public static final <T> T[] cleanNull(T ... objects) {
        if (null == objects) {
            return null;
        }
        List<Object> list = CommonUtils.cleanNullAsList(objects);
        return list.toArray((Object[])Array.newInstance(objects.getClass().getComponentType(), list.size()));
    }

    public static final <T> List<T> cleanNullAsList(T ... objects) {
        if (null == objects || 0 == objects.length) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(objects.length);
        for (T element : objects) {
            if (null == element) continue;
            list.add(element);
        }
        return list;
    }

    public static final <T> List<T> cleanNullAsList(Collection<T> objects) {
        if (null == objects) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(objects.size());
        for (T element : objects) {
            if (null == element) continue;
            list.add(element);
        }
        return list;
    }

    public static final <T> T[] toGenericArray(Collection<T> src) {
        if (null == src) {
            return null;
        }
        Object notNull = null;
        for (Object object : src) {
            if (null == object) continue;
            notNull = object;
            break;
        }
        if (null == notNull) {
            return null;
        }
        return src.toArray((Object[])Array.newInstance(notNull.getClass(), src.size()));
    }

    public static final <T> T[] toGenericArray(Collection<T> src, Class<T> componentType) {
        if (null == componentType) {
            throw new NullPointerException();
        }
        if (null == src) {
            return (Object[])Array.newInstance(componentType, 0);
        }
        return src.toArray((Object[])Array.newInstance(componentType, src.size()));
    }
}

