/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.utils;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public interface Synchronizer {
    public static final Synchronizer NO_OP_SYNCHRONIZER = new Synchronizer(){

        @Override
        public void beginRead() {
        }

        @Override
        public void endRead() {
        }

        @Override
        public void beginWrite() {
        }

        @Override
        public void endWrite() {
        }
    };

    public void beginRead();

    public void endRead();

    public void beginWrite();

    public void endWrite();

    public static class ReadWriteSynchronizer
    implements Synchronizer {
        private final ReadWriteLock lock;

        public ReadWriteSynchronizer(ReadWriteLock l) {
            this.lock = l != null ? l : ReadWriteSynchronizer.createDefaultLock();
        }

        public ReadWriteSynchronizer() {
            this(null);
        }

        @Override
        public void beginRead() {
            this.lock.readLock().lock();
        }

        @Override
        public void endRead() {
            this.lock.readLock().unlock();
        }

        @Override
        public void beginWrite() {
            this.lock.writeLock().lock();
        }

        @Override
        public void endWrite() {
            this.lock.writeLock().unlock();
        }

        private static ReadWriteLock createDefaultLock() {
            return new ReentrantReadWriteLock();
        }
    }
}

