/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.Address;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Config;
import jcifs.NetbiosAddress;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.http.NtlmHttpServletRequest;
import jcifs.http.NtlmSsp;
import jcifs.netbios.UniAddress;
import jcifs.smb.NtlmChallenge;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSessionInternal;
import jcifs.smb.SmbTransportInternal;
import jcifs.util.Hexdump;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NtlmHttpFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(NtlmHttpFilter.class);
    private String defaultDomain;
    private String domainController;
    private boolean loadBalance;
    private boolean enableBasic;
    private boolean insecureBasic;
    private String realm;
    private CIFSContext transportContext;
    private Address[] dcList = null;
    private long dcListExpiration;
    private int netbiosLookupRespLimit = 3;
    private long netbiosCacheTimeout = 36000L;
    private static int dcListCounter;

    public void init(FilterConfig filterConfig) throws ServletException {
        Properties p = new Properties();
        p.setProperty("jcifs.smb.client.soTimeout", "1800000");
        p.setProperty("jcifs.netbios.cachePolicy", "1200");
        p.setProperty("jcifs.smb.lmCompatibility", "0");
        p.setProperty("jcifs.smb.client.useExtendedSecurity", "false");
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("jcifs.")) continue;
            p.setProperty(name, filterConfig.getInitParameter(name));
        }
        try {
            this.defaultDomain = p.getProperty("jcifs.smb.client.domain");
            this.domainController = p.getProperty("jcifs.http.domainController");
            if (this.domainController == null) {
                this.domainController = this.defaultDomain;
                this.loadBalance = Config.getBoolean(p, "jcifs.http.loadBalance", true);
            }
            this.enableBasic = Boolean.valueOf(p.getProperty("jcifs.http.enableBasic"));
            this.insecureBasic = Boolean.valueOf(p.getProperty("jcifs.http.insecureBasic"));
            this.realm = p.getProperty("jcifs.http.basicRealm");
            this.netbiosLookupRespLimit = Config.getInt(p, "jcifs.netbios.lookupRespLimit", 3);
            this.netbiosCacheTimeout = Config.getInt(p, "jcifs.netbios.cachePolicy", 600) * 60;
            if (this.realm == null) {
                this.realm = "jCIFS";
            }
            this.transportContext = new BaseContext(new PropertyConfiguration(p));
        }
        catch (CIFSException ex) {
            throw new ServletException("Failed to initialize CIFS context");
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        NtlmPasswordAuthentication ntlm = this.negotiate(req, resp, false);
        if (ntlm == null) {
            return;
        }
        chain.doFilter((ServletRequest)new NtlmHttpServletRequest(req, ntlm), response);
    }

    protected NtlmPasswordAuthentication negotiate(HttpServletRequest req, HttpServletResponse resp, boolean skipAuthentication) throws IOException, ServletException {
        HttpSession ssn;
        boolean offerBasic;
        NtlmPasswordAuthentication ntlm = null;
        String msg = req.getHeader("Authorization");
        boolean bl = offerBasic = this.enableBasic && (this.insecureBasic || req.isSecure());
        if (msg != null && (msg.startsWith("NTLM ") || offerBasic && msg.startsWith("Basic "))) {
            Address dc;
            if (msg.startsWith("NTLM ")) {
                byte[] challenge;
                HttpSession ssn2 = req.getSession();
                if (this.loadBalance) {
                    NtlmChallenge chal = (NtlmChallenge)ssn2.getAttribute("NtlmHttpChal");
                    if (chal == null) {
                        chal = this.getChallengeForDomain(this.defaultDomain);
                        ssn2.setAttribute("NtlmHttpChal", (Object)chal);
                    }
                    dc = chal.dc;
                    challenge = chal.challenge;
                } else {
                    dc = this.getTransportContext().getNameServiceClient().getByName(this.domainController, true);
                    challenge = this.getTransportContext().getTransportPool().getChallenge(this.getTransportContext(), dc);
                }
                ntlm = NtlmSsp.authenticate(this.getTransportContext(), req, resp, challenge);
                if (ntlm == null) {
                    return null;
                }
                ssn2.removeAttribute("NtlmHttpChal");
            } else {
                String auth = new String(Base64.decode((String)msg.substring(6)), "US-ASCII");
                int index = auth.indexOf(58);
                String user = index != -1 ? auth.substring(0, index) : auth;
                String password = index != -1 ? auth.substring(index + 1) : "";
                index = user.indexOf(92);
                if (index == -1) {
                    index = user.indexOf(47);
                }
                String domain = index != -1 ? user.substring(0, index) : this.defaultDomain;
                user = index != -1 ? user.substring(index + 1) : user;
                ntlm = new NtlmPasswordAuthentication(this.getTransportContext(), domain, user, password);
                dc = this.getTransportContext().getNameServiceClient().getByName(this.domainController, true);
            }
            try {
                this.getTransportContext().getTransportPool().logon(this.getTransportContext(), dc);
                if (log.isDebugEnabled()) {
                    log.debug("NtlmHttpFilter: " + ntlm + " successfully authenticated against " + dc);
                }
            }
            catch (SmbAuthException sae) {
                HttpSession ssn3;
                log.warn("NtlmHttpFilter: " + ntlm.getName() + ": 0x" + Hexdump.toHexString(sae.getNtStatus(), 8) + ": " + sae);
                if (sae.getNtStatus() == -1073741819 && (ssn3 = req.getSession(false)) != null) {
                    ssn3.removeAttribute("NtlmHttpAuth");
                }
                resp.setHeader("WWW-Authenticate", "NTLM");
                if (offerBasic) {
                    resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
                }
                resp.setStatus(401);
                resp.setContentLength(0);
                resp.flushBuffer();
                return null;
            }
            req.getSession().setAttribute("NtlmHttpAuth", (Object)ntlm);
        } else if (!(skipAuthentication || (ssn = req.getSession(false)) != null && (ntlm = (NtlmPasswordAuthentication)ssn.getAttribute("NtlmHttpAuth")) != null)) {
            resp.setHeader("WWW-Authenticate", "NTLM");
            if (offerBasic) {
                resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            }
            resp.setStatus(401);
            resp.setContentLength(0);
            resp.flushBuffer();
            return null;
        }
        return ntlm;
    }

    private synchronized NtlmChallenge getChallengeForDomain(String domain) throws UnknownHostException, ServletException {
        if (domain == null) {
            throw new ServletException("A domain was not specified");
        }
        long now = System.currentTimeMillis();
        int retry = 1;
        do {
            if (this.dcListExpiration < now) {
                NetbiosAddress[] list = this.getTransportContext().getNameServiceClient().getNbtAllByName(domain, 28, null, null);
                this.dcListExpiration = now + this.netbiosCacheTimeout * 1000L;
                if (list != null && list.length > 0) {
                    this.dcList = list;
                } else {
                    this.dcListExpiration = now + 900000L;
                    log.warn("Failed to retrieve DC list from WINS");
                }
            }
            int max = Math.min(this.dcList.length, this.netbiosLookupRespLimit);
            for (int j = 0; j < max; ++j) {
                int i;
                if (this.dcList[i = dcListCounter++ % max] == null) continue;
                try {
                    return NtlmHttpFilter.interrogate(this.getTransportContext(), this.dcList[i]);
                }
                catch (SmbException se) {
                    log.warn("Failed validate DC: " + this.dcList[i], se);
                    this.dcList[i] = null;
                }
            }
            this.dcListExpiration = 0L;
        } while (retry-- > 0);
        this.dcListExpiration = now + 900000L;
        throw new UnknownHostException("Failed to negotiate with a suitable domain controller for " + domain);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NtlmChallenge interrogate(CIFSContext tf, Address addr) throws SmbException {
        UniAddress dc = new UniAddress(addr);
        try (SmbTransportInternal trans = tf.getTransportPool().getSmbTransport(tf, dc, 0, false, tf.hasDefaultCredentials() && tf.getConfig().isIpcSigningEnforced()).unwrap(SmbTransportInternal.class);){
            if (!tf.hasDefaultCredentials()) {
                trans.ensureConnected();
                log.warn("Default credentials (jcifs.smb.client.username/password) not specified. SMB signing may not work propertly.  Skipping DC interrogation.");
            } else {
                try (SmbSessionInternal ssn = trans.getSmbSession(tf.withDefaultCredentials()).unwrap(SmbSessionInternal.class);){
                    ssn.treeConnectLogon();
                }
            }
            NtlmChallenge ntlmChallenge = new NtlmChallenge(trans.getServerEncryptionKey(), dc);
            return ntlmChallenge;
        }
        catch (SmbException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SmbException("Connection failed", (Throwable)e);
        }
    }

    private CIFSContext getTransportContext() {
        return this.transportContext;
    }

    public void setFilterConfig(FilterConfig f) {
        try {
            this.init(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FilterConfig getFilterConfig() {
        return null;
    }
}

