/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1;

import java.security.MessageDigest;
import java.util.Date;
import jcifs.Configuration;
import jcifs.internal.CommonServerMessageBlock;
import jcifs.internal.SMBSigningDigest;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.smb1.com.SmbComReadAndXResponse;
import jcifs.internal.smb1.trans.nt.SmbComNtCancel;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTransportInternal;
import jcifs.util.Crypto;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMB1SigningDigest
implements SMBSigningDigest {
    private static final Logger log = LoggerFactory.getLogger(SMB1SigningDigest.class);
    private MessageDigest digest = Crypto.getMD5();
    private byte[] macSigningKey;
    private boolean bypass = false;
    private int updates;
    private int signSequence;

    public SMB1SigningDigest(byte[] macSigningKey, boolean bypass) {
        this(macSigningKey, bypass, 0);
    }

    public SMB1SigningDigest(byte[] macSigningKey, boolean bypass, int initialSequence) {
        this.macSigningKey = macSigningKey;
        this.signSequence = initialSequence;
        this.bypass = bypass;
        if (log.isTraceEnabled()) {
            log.trace("macSigningKey:");
            log.trace(Hexdump.toHexString(macSigningKey, 0, macSigningKey.length));
        }
    }

    public SMB1SigningDigest(byte[] macSigningKey) {
        this.macSigningKey = macSigningKey;
    }

    public SMB1SigningDigest(byte[] macSigningKey, int initialSequence) {
        this.macSigningKey = macSigningKey;
        this.signSequence = initialSequence;
    }

    public SMB1SigningDigest(SmbTransportInternal transport, NtlmPasswordAuthenticator auth) throws SmbException {
        try {
            byte[] serverEncryptionKey = transport.getServerEncryptionKey();
            switch (transport.getContext().getConfig().getLanManCompatibility()) {
                case 0: 
                case 1: 
                case 2: {
                    this.macSigningKey = new byte[40];
                    auth.getUserSessionKey(transport.getContext(), serverEncryptionKey, this.macSigningKey, 0);
                    System.arraycopy(auth.getUnicodeHash(transport.getContext(), serverEncryptionKey), 0, this.macSigningKey, 16, 24);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.macSigningKey = new byte[16];
                    auth.getUserSessionKey(transport.getContext(), serverEncryptionKey, this.macSigningKey, 0);
                    break;
                }
                default: {
                    this.macSigningKey = new byte[40];
                    auth.getUserSessionKey(transport.getContext(), serverEncryptionKey, this.macSigningKey, 0);
                    System.arraycopy(auth.getUnicodeHash(transport.getContext(), serverEncryptionKey), 0, this.macSigningKey, 16, 24);
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new SmbException("", (Throwable)ex);
        }
        if (log.isTraceEnabled()) {
            log.trace("LM_COMPATIBILITY=" + transport.getContext().getConfig().getLanManCompatibility());
            log.trace(Hexdump.toHexString(this.macSigningKey, 0, this.macSigningKey.length));
        }
    }

    public void update(byte[] input, int offset, int len) {
        if (log.isTraceEnabled()) {
            log.trace("update: " + this.updates + " " + offset + ":" + len);
            log.trace(Hexdump.toHexString(input, offset, Math.min(len, 256)));
        }
        if (len == 0) {
            return;
        }
        this.digest.update(input, offset, len);
        ++this.updates;
    }

    public byte[] digest() {
        byte[] b = this.digest.digest();
        if (log.isTraceEnabled()) {
            log.trace("digest: ");
            log.trace(Hexdump.toHexString(b, 0, b.length));
        }
        this.updates = 0;
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sign(byte[] data, int offset, int length, CommonServerMessageBlock request, CommonServerMessageBlock response) {
        if (log.isTraceEnabled()) {
            log.trace("Signing with seq " + this.signSequence);
        }
        ((ServerMessageBlock)request).setSignSeq(this.signSequence);
        if (response != null) {
            ((ServerMessageBlock)response).setSignSeq(this.signSequence + 1);
        }
        try {
            this.update(this.macSigningKey, 0, this.macSigningKey.length);
            int index = offset + 14;
            for (int i = 0; i < 8; ++i) {
                data[index + i] = 0;
            }
            SMBUtil.writeInt4(this.signSequence, data, index);
            this.update(data, offset, length);
            System.arraycopy(this.digest(), 0, data, index, 8);
            if (this.bypass) {
                this.bypass = false;
                System.arraycopy("BSRSPYL ".getBytes(), 0, data, index, 8);
            }
        }
        catch (Exception ex) {
            log.error("Signature failed", ex);
        }
        finally {
            this.signSequence = request instanceof SmbComNtCancel ? ++this.signSequence : (this.signSequence += 2);
        }
    }

    @Override
    public boolean verify(byte[] data, int offset, int l, int extraPad, CommonServerMessageBlock m) {
        ServerMessageBlock msg = (ServerMessageBlock)m;
        if ((msg.getFlags2() & 4) == 0) {
            log.warn("Expected signed response, but is not signed");
            return false;
        }
        this.update(this.macSigningKey, 0, this.macSigningKey.length);
        int index = offset;
        this.update(data, index, 14);
        index += 14;
        byte[] sequence = new byte[8];
        SMBUtil.writeInt4(msg.getSignSeq(), sequence, 0);
        this.update(sequence, 0, sequence.length);
        index += 8;
        if (msg.getCommand() == 46) {
            SmbComReadAndXResponse raxr = (SmbComReadAndXResponse)msg;
            int length = msg.getLength() - raxr.getDataLength();
            this.update(data, index, length - 14 - 8);
            this.update(raxr.getData(), raxr.getOffset(), raxr.getDataLength());
        } else {
            this.update(data, index, msg.getLength() - 14 - 8);
        }
        byte[] signature = this.digest();
        for (int i = 0; i < 8; ++i) {
            if (signature[i] == data[offset + 14 + i]) continue;
            if (log.isDebugEnabled()) {
                log.debug("signature verification failure");
                log.debug("Expect: " + Hexdump.toHexString(signature, 0, 8));
                log.debug("Have: " + Hexdump.toHexString(data, offset + 14, 8));
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "MacSigningKey=" + Hexdump.toHexString(this.macSigningKey, 0, this.macSigningKey.length);
    }

    public static void writeUTime(Configuration cfg, long t, byte[] dst, int dstIndex) {
        if (t == 0L || t == -1L) {
            SMBUtil.writeInt4(-1L, dst, dstIndex);
            return;
        }
        if (cfg.getLocalTimezone().inDaylightTime(new Date())) {
            if (!cfg.getLocalTimezone().inDaylightTime(new Date(t))) {
                t -= 3600000L;
            }
        } else if (cfg.getLocalTimezone().inDaylightTime(new Date(t))) {
            t += 3600000L;
        }
        SMBUtil.writeInt4((int)(t / 1000L), dst, dstIndex);
    }
}

