/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.trans2;

import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.internal.AllocInfo;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.fscc.FileFsFullSizeInformation;
import jcifs.internal.fscc.FileFsSizeInformation;
import jcifs.internal.fscc.FileSystemInformation;
import jcifs.internal.fscc.SmbInfoAllocation;
import jcifs.internal.smb1.trans.SmbComTransactionResponse;

public class Trans2QueryFSInformationResponse
extends SmbComTransactionResponse {
    private int informationLevel;
    private FileSystemInformation info;

    public Trans2QueryFSInformationResponse(Configuration config, int informationLevel) {
        super(config);
        this.informationLevel = informationLevel;
        this.setCommand(50);
        this.setSubCommand((byte)3);
    }

    public int getInformationLevel() {
        return this.informationLevel;
    }

    public FileSystemInformation getInfo() {
        return this.info;
    }

    public <T extends FileSystemInformation> T getInfo(Class<T> clazz) throws CIFSException {
        if (!clazz.isAssignableFrom(this.info.getClass())) {
            throw new CIFSException("Incompatible file information class");
        }
        return (T)this.getInfo();
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        AllocInfo inf = this.createInfo();
        if (inf != null) {
            bufferIndex += inf.decode(buffer, bufferIndex, this.getDataCount());
            this.info = inf;
        }
        return bufferIndex - start;
    }

    private AllocInfo createInfo() {
        AllocInfo inf;
        switch (this.informationLevel) {
            case -1: {
                inf = new SmbInfoAllocation();
                break;
            }
            case 3: {
                inf = new FileFsSizeInformation();
                break;
            }
            case 7: {
                inf = new FileFsFullSizeInformation();
                break;
            }
            default: {
                return null;
            }
        }
        return inf;
    }

    @Override
    public String toString() {
        return new String("Trans2QueryFSInformationResponse[" + super.toString() + "]");
    }
}

