/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.net.MalformedURLException;
import jcifs.CIFSException;
import jcifs.CloseableIterator;
import jcifs.ResourceFilter;
import jcifs.SmbResource;
import jcifs.smb.FileEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FileEntryAdapterIterator
implements CloseableIterator<SmbResource> {
    private static final Logger log = LoggerFactory.getLogger(FileEntryAdapterIterator.class);
    private final CloseableIterator<FileEntry> delegate;
    private final ResourceFilter filter;
    private final SmbResource parent;
    private SmbResource next;

    public FileEntryAdapterIterator(SmbResource parent, CloseableIterator<FileEntry> delegate, ResourceFilter filter) {
        this.parent = parent;
        this.delegate = delegate;
        this.filter = filter;
        this.next = this.advance();
    }

    protected final SmbResource getParent() {
        return this.parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SmbResource advance() {
        while (this.delegate.hasNext()) {
            FileEntry fe = (FileEntry)this.delegate.next();
            if (this.filter == null) {
                try {
                    return this.adapt(fe);
                }
                catch (MalformedURLException e) {
                    log.error("Failed to create child URL", e);
                    continue;
                }
            }
            try {
                SmbResource r = this.adapt(fe);
                Throwable throwable = null;
                try {
                    if (!this.filter.accept(r)) continue;
                    SmbResource smbResource = r;
                    return smbResource;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (r == null) continue;
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    r.close();
                }
            }
            catch (MalformedURLException e) {
                log.error("Failed to create child URL", e);
            }
            catch (CIFSException e) {
                log.error("Filter failed", e);
            }
        }
        return null;
    }

    protected abstract SmbResource adapt(FileEntry var1) throws MalformedURLException;

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public SmbResource next() {
        SmbResource n = this.next;
        this.next = this.advance();
        return n;
    }

    @Override
    public void close() throws CIFSException {
        this.delegate.close();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }
}

