/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import jcifs.CIFSException;
import jcifs.smb.CredentialsInternal;
import jcifs.smb.Kerb5Authenticator;
import jcifs.smb.SmbRenewableCredentials;
import jcifs.smb.StaticJAASConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAASAuthenticator
extends Kerb5Authenticator
implements CallbackHandler,
SmbRenewableCredentials {
    private static final Logger log = LoggerFactory.getLogger(JAASAuthenticator.class);
    private static final long serialVersionUID = -1648420815038372844L;
    private String serviceName;
    private Subject cachedSubject;
    private Configuration configuration;

    public JAASAuthenticator() {
        this("jcifs");
    }

    public JAASAuthenticator(String serviceName) {
        super(null);
        this.serviceName = serviceName;
    }

    public JAASAuthenticator(String serviceName, String domain, String username, String password) {
        super((Subject)null, domain, username, password);
        this.serviceName = serviceName;
    }

    public JAASAuthenticator(String domain, String username, String password) {
        this(new HashMap(), domain, username, password);
    }

    public JAASAuthenticator(Map<String, ?> properties, String domain, String username, String password) {
        super((Subject)null, domain, username, password);
        this.serviceName = "static";
        this.configuration = new StaticJAASConfiguration(properties);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isGuest() {
        return false;
    }

    @Override
    public Kerb5Authenticator clone() {
        JAASAuthenticator auth = new JAASAuthenticator();
        JAASAuthenticator.cloneInternal(auth, this);
        return auth;
    }

    protected static void cloneInternal(JAASAuthenticator to, JAASAuthenticator from) {
        Kerb5Authenticator.cloneInternal(to, from);
        to.serviceName = from.serviceName;
        to.configuration = from.configuration;
        to.cachedSubject = from.cachedSubject;
    }

    @Override
    public void refresh() throws CIFSException {
        log.debug("Refreshing JAAS credentials");
        this.cachedSubject = null;
    }

    @Override
    public synchronized Subject getSubject() {
        if (this.cachedSubject != null) {
            return this.cachedSubject;
        }
        try {
            log.debug("Logging on");
            Subject ps = super.getSubject();
            LoginContext lc = this.configuration != null ? new LoginContext(this.serviceName, ps, this, this.configuration) : (ps != null ? new LoginContext(this.serviceName, ps, this) : new LoginContext(this.serviceName, this));
            lc.login();
            Subject s = lc.getSubject();
            if (log.isDebugEnabled()) {
                log.debug("Got subject: " + s.getPrincipals());
            }
            if (log.isTraceEnabled()) {
                log.trace("Got subject " + s);
            }
            this.cachedSubject = s;
            return this.cachedSubject;
        }
        catch (LoginException e) {
            log.error("Failed to create login context", e);
            this.cachedSubject = new Subject();
            return null;
        }
    }

    @Override
    public CredentialsInternal renew() {
        log.debug("Renewing credentials");
        this.cachedSubject = null;
        this.getSubject();
        return this;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            if (log.isDebugEnabled()) {
                log.debug("Got callback " + cb.getClass().getName());
            }
            if (cb instanceof NameCallback) {
                NameCallback nc = (NameCallback)cb;
                String userDomain = this.getSpecifiedUserDomain();
                if (this.getUsername() == null || userDomain == null) continue;
                nc.setName(this.getUsername() + "@" + userDomain);
                continue;
            }
            if (!(cb instanceof PasswordCallback)) continue;
            PasswordCallback pc = (PasswordCallback)cb;
            if (this.getPassword() == null) continue;
            pc.setPassword(this.getPassword().toCharArray());
        }
    }
}

