/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cli;

import java.util.Map;
import java.util.logging.Logger;
import net.gdface.cli.AbstractConfiguration;
import net.gdface.cli.CommonCliConstants;
import net.gdface.cli.Context;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public abstract class BaseAppConfig
extends AbstractConfiguration
implements CommonCliConstants {
    protected static final Logger logger = Logger.getLogger(BaseAppConfig.class.getSimpleName());
    protected final Options options = new Options();
    protected final Context defaultValue = Context.builder().build();

    protected BaseAppConfig() {
    }

    @Override
    protected Map<String, Object> getDefaultValueMap() {
        return this.defaultValue.getContext();
    }

    public BaseAppConfig parseCommandLine(String[] args) {
        HelpFormatter formatter = new HelpFormatter();
        DefaultParser parser = new DefaultParser();
        CommandLine cl = null;
        Options opts = this.getOptions();
        opts.addOption("h", "help", false, "Print this usage information");
        boolean exit = false;
        try {
            cl = parser.parse(opts, args);
            if (!cl.hasOption("h")) {
                if (cl.hasOption("D")) {
                    this.setSystemProperty(cl.getOptionValues("D"));
                }
                this.loadConfig(opts, cl);
            } else {
                exit = true;
            }
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            exit = true;
        }
        if (exit) {
            formatter.printHelp(this.getCmdLineSyntax(), this.getHeader(), this.getOptions(), this.getFooter());
            System.exit(1);
        }
        return this;
    }

    private void setSystemProperty(String[] properties) {
        if (properties.length % 2 != 0) {
            throw new IllegalArgumentException("INVALID properties length");
        }
        for (int i = 0; i < properties.length; i += 2) {
            System.setProperty(properties[i], properties[i + 1]);
            logger.info(String.format("set property [%s]=[%s]", properties[i], properties[i + 1]));
        }
    }

    protected String getCmdLineSyntax() {
        return String.format("%s [options]", this.getAppName());
    }

    public Options getOptions() {
        return this.options;
    }

    protected String getAppName() {
        return "Appname";
    }

    protected String getHeader() {
        return null;
    }

    protected String getFooter() {
        return null;
    }
}

