/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.image;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import net.gdface.image.BaseLazyImage;
import net.gdface.image.ImageErrorException;
import net.gdface.image.ImageMatrix;
import net.gdface.image.ImageUtil;
import net.gdface.image.NotImageException;
import net.gdface.image.UnsupportedFormatException;
import net.gdface.utils.Assert;
import net.gdface.utils.FaceUtilits;

public class LazyImage
extends BaseLazyImage
implements ImageMatrix {
    private Rectangle rectangle = null;
    private ImageReader imageReader;
    private MemoryCacheImageInputStream imageInputstream;
    private BufferedImage bufferedImage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LazyImage open() throws UnsupportedFormatException, NotImageException {
        try {
            if (this.bufferedImage == null) {
                Iterator<ImageReader> it = ImageIO.getImageReaders(this.getImageInputstream());
                if (!it.hasNext()) throw new NotImageException("NOT FOUND MATCHED ImageReader");
                try {
                    this.imageReader = it.next();
                    this.imageReader.setInput(this.getImageInputstream(), true, true);
                    this.suffix = this.imageReader.getFormatName().trim().toLowerCase();
                    this.width = this.imageReader.getWidth(0);
                    this.height = this.imageReader.getHeight(0);
                }
                catch (Exception e) {
                    throw new UnsupportedFormatException(e);
                }
            } else {
                this.width = this.bufferedImage.getWidth();
                this.height = this.bufferedImage.getHeight();
            }
            LazyImage lazyImage = this;
            return lazyImage;
        }
        finally {
            if (this.autoClose) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected BufferedImage read(ImageReadParam param) throws UnsupportedFormatException {
        try {
            Object imageReader;
            if (null == this.bufferedImage || null != param) {
                imageReader = this.getImageReader();
                if (null == ((ImageReader)imageReader).getInput()) {
                    ((ImageReader)imageReader).setInput(this.getImageInputstream(), true, true);
                }
                BufferedImage bi = ((ImageReader)imageReader).read(0, null == param ? ((ImageReader)imageReader).getDefaultReadParam() : param);
                if (null == param) {
                    this.bufferedImage = bi;
                } else {
                    BufferedImage bufferedImage = bi;
                    return bufferedImage;
                }
            }
            imageReader = this.bufferedImage;
            return imageReader;
        }
        catch (Exception e) {
            throw new UnsupportedFormatException(e);
        }
        finally {
            if (this.autoClose) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public BufferedImage read() throws UnsupportedFormatException {
        return this.read(null);
    }

    public BufferedImage read(Rectangle rect, ImageTypeSpecifier destinationType) throws UnsupportedFormatException {
        ImageReadParam param = this.getImageReader().getDefaultReadParam();
        if (rect != null && !rect.equals(this.getRectangle())) {
            param.setSourceRegion(rect);
        }
        param.setDestinationType(destinationType);
        if (null != destinationType) {
            param.setDestination(destinationType.createBufferedImage(this.width, this.height));
        }
        return this.read(param);
    }

    @Override
    public byte[] getMatrixRGBA() throws UnsupportedFormatException {
        if (this.matrixRGBA == null) {
            this.matrixRGBA = ImageUtil.getMatrixRGBA(this.read());
        }
        return this.matrixRGBA;
    }

    @Override
    public byte[] getMatrixRGB() throws UnsupportedFormatException {
        if (this.matrixRGB == null) {
            this.matrixRGB = ImageUtil.getMatrixRGB(this.read());
        }
        return this.matrixRGB;
    }

    @Override
    public byte[] getMatrixBGR() throws UnsupportedFormatException {
        if (this.matrixBGR == null) {
            this.matrixBGR = ImageUtil.getMatrixBGR(this.read());
        }
        return this.matrixBGR;
    }

    @Override
    public byte[] getMatrixGray() throws UnsupportedFormatException {
        if (null == this.matrixGray) {
            this.matrixGray = ImageUtil.getMatrixGRAY(this.read());
        }
        return this.matrixGray;
    }

    @Override
    public byte[] wirtePNGBytes() {
        try {
            if ("PNG".equalsIgnoreCase(this.getSuffix()) && this.getImgBytes() != null) {
                return this.getImgBytes();
            }
            return ImageUtil.wirtePNGBytes(this.read());
        }
        catch (UnsupportedFormatException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] wirteJPEGBytes() {
        try {
            if ("JPEG".equalsIgnoreCase(this.getSuffix()) && this.getImgBytes() != null) {
                return this.getImgBytes();
            }
            return ImageUtil.wirteJPEGBytes(this.read(), Float.valueOf(0.9f));
        }
        catch (UnsupportedFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static LazyImage create(byte[] imgBytes) throws NotImageException, UnsupportedFormatException {
        return new LazyImage(imgBytes).open();
    }

    public static LazyImage create(BufferedImage bufferedImage) {
        try {
            return new LazyImage(bufferedImage).open();
        }
        catch (ImageErrorException e) {
            throw new RuntimeException(e);
        }
    }

    public static LazyImage create(File file, String md5) throws NotImageException, UnsupportedFormatException {
        try {
            return new LazyImage(file, md5).open();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> LazyImage create(T src) throws NotImageException, UnsupportedFormatException {
        try {
            return new LazyImage(src).open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LazyImage(BufferedImage bufferedImage) {
        Assert.notNull(bufferedImage, "bufferedImage");
        this.bufferedImage = bufferedImage;
    }

    public LazyImage(byte[] imgBytes) {
        super(imgBytes);
    }

    public LazyImage(File src, String md5) throws FileNotFoundException {
        super(src, md5);
    }

    public <T> LazyImage(T src) throws IOException {
        this(FaceUtilits.getBytesNotEmpty(src));
    }

    private ImageInputStream getImageInputstream() {
        if (null == this.imageInputstream) {
            if (null == this.imgBytes) {
                if (null == this.localFile) {
                    throw new IllegalArgumentException("while isValidImage be true localFile & imgBytes can't be NULL all");
                }
                try {
                    this.imageInputstream = new MemoryCacheImageInputStream(new FileInputStream(this.localFile));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.imageInputstream = new MemoryCacheImageInputStream(new ByteArrayInputStream(this.imgBytes));
            }
        }
        return this.imageInputstream;
    }

    private ImageReader getImageReader() throws IllegalStateException {
        if (null == this.imageReader) {
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName(this.suffix);
            if (it.hasNext()) {
                this.imageReader = it.next();
            } else {
                throw new IllegalStateException(String.format("invalid suffix %s", this.suffix));
            }
        }
        return this.imageReader;
    }

    @Override
    public void close() throws IOException {
        if (null != this.imageReader) {
            this.imageReader.dispose();
            this.imageReader = null;
        }
        if (null != this.imageInputstream) {
            this.imageInputstream.close();
            this.imageInputstream = null;
        }
        super.close();
    }

    @Override
    public void finalize() throws Throwable {
        this.bufferedImage = null;
        this.rectangle = null;
        super.finalize();
    }

    public Rectangle getRectangle() {
        if (null == this.rectangle) {
            this.rectangle = new Rectangle(0, 0, this.width, this.height);
        }
        return this.rectangle;
    }
}

