/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static final <L, R> DualTransformer<L, R> asDualTransformer(final Function<L, R> t1, final Function<R, L> t2) {
        CollectionUtils.checkNotNull(t1);
        CollectionUtils.checkNotNull(t2);
        return new DualTransformer<L, R>(){

            @Override
            public R toRight(L input) {
                return t1.apply(input);
            }

            @Override
            public L fromRight(R input) {
                return t2.apply(input);
            }
        };
    }

    public static final <L, R> Function<L, R> asToRightTransformer(final DualTransformer<L, R> dual) {
        CollectionUtils.checkNotNull(dual);
        return new Function<L, R>(){

            @Override
            public R apply(L input) {
                return dual.toRight(input);
            }
        };
    }

    public static final <L, R> Function<R, L> asFromRightTransformer(final DualTransformer<L, R> dual) {
        CollectionUtils.checkNotNull(dual);
        return new Function<R, L>(){

            @Override
            public L apply(R input) {
                return dual.fromRight(input);
            }
        };
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <C extends Collection<?>> C checkNotNullElement(C c) {
        if (null != c) {
            for (Object e : c) {
                CollectionUtils.checkNotNull(e, "element of collection must not be null");
            }
        }
        return c;
    }

    static <V> V safeGet(Map<?, V> map, Object key) {
        CollectionUtils.checkNotNull(map);
        try {
            return map.get(key);
        }
        catch (ClassCastException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static final <K1, K2, V> Map<K2, V> tranformKeys(Map<K1, V> fromMap, Function<K1, K2> transformer2, Function<K2, K1> transformer1) {
        return CollectionUtils.tranformKeys(fromMap, CollectionUtils.asDualTransformer(transformer2, transformer1));
    }

    public static final <K1, K2, V> Map<K2, V> tranformKeys(Map<K1, V> fromMap, DualTransformer<K1, K2> transformer) {
        return new TransformedMap<K1, K2, V>(fromMap, transformer);
    }

    public static final <E1, E2> Set<E2> transform(Set<E1> fromSet, Function<E1, E2> transformer2, Function<E2, E1> transformer1) {
        return CollectionUtils.transform(fromSet, CollectionUtils.asDualTransformer(transformer2, transformer1));
    }

    public static final <E1, E2> Set<E2> transform(Set<E1> fromSet, DualTransformer<E1, E2> transformer) {
        return new TransformedSet<E1, E2>(fromSet, transformer);
    }

    public static <F, T> Iterator<T> transform(Iterator<F> fromIterator, Function<? super F, ? extends T> transformer) {
        return new TransformedIterator<F, T>(fromIterator, transformer);
    }

    public static <K, V> Map<K, V> merge(Iterator<K> keys, Iterator<V> values) {
        if (keys == null || values == null) {
            throw new NullPointerException("keyItor or valueItor is null");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        while (keys.hasNext() && values.hasNext()) {
            K key = keys.next();
            if (key == null) continue;
            map.put(key, values.next());
        }
        if (keys.hasNext() || values.hasNext()) {
            throw new IllegalArgumentException("mismatch size of keys and values");
        }
        return map;
    }

    public static <K, V> Map<K, V> merge(Iterable<K> keys, Iterable<V> values) {
        if (keys == null || values == null) {
            throw new NullPointerException("keys or values is null");
        }
        return CollectionUtils.merge(keys.iterator(), values.iterator());
    }

    public static <K, V> Map<K, V> merge(K[] keys, V[] values) {
        if (keys == null || values == null) {
            throw new NullPointerException("keys or values is null");
        }
        return CollectionUtils.merge(Arrays.asList(keys), Arrays.asList(values));
    }

    static class TransformedMap<K1, K2, V>
    extends AbstractMap<K2, V> {
        final Map<K1, V> fromMap;
        private DualTransformer<K1, K2> transformer;

        TransformedMap(Map<K1, V> fromMap, DualTransformer<K1, K2> transformer) {
            CollectionUtils.checkNotNull(fromMap);
            CollectionUtils.checkNotNull(transformer);
            this.fromMap = fromMap;
            this.transformer = transformer;
        }

        @Override
        public V get(Object key) {
            try {
                return this.fromMap.get(this.transformer.fromRight(key));
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        @Override
        public boolean containsKey(Object key) {
            try {
                return this.fromMap.containsKey(this.transformer.fromRight(key));
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public V put(K2 key, V value) {
            return this.fromMap.put(this.transformer.fromRight(key), value);
        }

        @Override
        public V remove(Object key) {
            try {
                return this.fromMap.remove(this.transformer.fromRight(key));
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        @Override
        public Set<Map.Entry<K2, V>> entrySet() {
            return new AbstractEntrySet<K2, V>(){

                @Override
                Map<K2, V> map() {
                    return TransformedMap.this;
                }

                @Override
                public Iterator<Map.Entry<K2, V>> iterator() {
                    return CollectionUtils.transform(TransformedMap.this.fromMap.entrySet().iterator(), new Function<Map.Entry<K1, V>, Map.Entry<K2, V>>(){

                        @Override
                        public Map.Entry<K2, V> apply(Map.Entry<K1, V> input) {
                            return new TransformedEntry(input, CollectionUtils.asToRightTransformer(TransformedMap.this.transformer));
                        }
                    });
                }
            };
        }

        static class TransformedEntry<K1, K2, V>
        implements Map.Entry<K2, V> {
            final Map.Entry<K1, V> fromEntry;
            final Function<K1, K2> transformer2;

            TransformedEntry(Map.Entry<K1, V> fromEntry, Function<K1, K2> transformer2) {
                CollectionUtils.checkNotNull(fromEntry);
                this.fromEntry = fromEntry;
                CollectionUtils.checkNotNull(transformer2);
                this.transformer2 = transformer2;
            }

            @Override
            public K2 getKey() {
                return this.transformer2.apply(this.fromEntry.getKey());
            }

            @Override
            public V getValue() {
                return this.fromEntry.getValue();
            }

            @Override
            public V setValue(V value) {
                return this.fromEntry.setValue(value);
            }

            @Override
            public boolean equals(Object object) {
                if (object instanceof TransformedEntry) {
                    return this.fromEntry.equals((TransformedEntry)object);
                }
                return super.equals(object);
            }

            @Override
            public int hashCode() {
                return this.fromEntry.hashCode();
            }

            public String toString() {
                return this.fromEntry.toString();
            }
        }

        static abstract class AbstractEntrySet<K, V>
        extends AbstractSet<Map.Entry<K, V>> {
            AbstractEntrySet() {
            }

            abstract Map<K, V> map();

            @Override
            public int size() {
                return this.map().size();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    V value = CollectionUtils.safeGet(this.map(), key);
                    return Objects.equals(value, entry.getValue()) && (value != null || this.map().containsKey(entry.getKey()));
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (this.contains(o)) {
                    Map.Entry entry = (Map.Entry)o;
                    return this.map().keySet().remove(entry.getKey());
                }
                return false;
            }
        }
    }

    static class TransformedSet<E1, E2>
    extends AbstractSet<E2> {
        final Set<E1> fromSet;
        private final DualTransformer<E1, E2> transformer;

        TransformedSet(Set<E1> fromSet, DualTransformer<E1, E2> transformer) {
            CollectionUtils.checkNotNull(fromSet);
            CollectionUtils.checkNotNull(transformer);
            this.fromSet = fromSet;
            this.transformer = transformer;
        }

        @Override
        public int size() {
            return this.fromSet.size();
        }

        @Override
        public Iterator<E2> iterator() {
            return CollectionUtils.transform(this.fromSet.iterator(), CollectionUtils.asToRightTransformer(this.transformer));
        }

        @Override
        public boolean add(E2 e) {
            return this.fromSet.add(this.transformer.fromRight(e));
        }

        @Override
        public boolean contains(Object o) {
            try {
                return this.fromSet.contains(this.transformer.fromRight(o));
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public boolean remove(Object o) {
            try {
                return this.fromSet.remove(this.transformer.fromRight(o));
            }
            catch (ClassCastException e) {
                return false;
            }
        }
    }

    static class TransformedIterator<F, T>
    implements Iterator<T> {
        final Iterator<? extends F> backingIterator;
        private Function<? super F, ? extends T> transformer;

        TransformedIterator(Iterator<? extends F> backingIterator, Function<? super F, ? extends T> transformer) {
            this.backingIterator = CollectionUtils.checkNotNull(backingIterator);
            this.transformer = CollectionUtils.checkNotNull(transformer);
        }

        @Override
        public final boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public final T next() {
            return this.transformer.apply(this.backingIterator.next());
        }

        @Override
        public final void remove() {
            this.backingIterator.remove();
        }
    }

    public static interface DualTransformer<L, R> {
        public R toRight(L var1);

        public L fromRight(R var1);
    }

    public static interface Function<F, T> {
        public T apply(F var1);
    }
}

