/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;

public class ConfigUtils {
    private static final String JAR_SUFFIX = ".jar";

    public static Properties loadAllProperties(String propFile, String confFolder, String envVar, Class<?> clazz, boolean showProp) {
        if (null == propFile || propFile.isEmpty()) {
            throw new IllegalArgumentException("the argument 'propFile' must not be null or empty");
        }
        if (null == confFolder) {
            confFolder = "conf";
        }
        if (null == clazz) {
            clazz = ConfigUtils.class;
        }
        String fileSeparator = System.getProperty("file.separator");
        String propPath = confFolder.concat(System.getProperty("file.separator")).concat(propFile);
        Properties props = new Properties();
        HashSet<File> loadedFiles = new HashSet<File>();
        try {
            URL url = clazz.getClassLoader().getResource(propPath.replace(fileSeparator, "/"));
            if (null == url) {
                throw new ExceptionInInitializerError(String.format("not found default properties %s", propPath));
            }
            ConfigUtils.loadProperties(url, props);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(String.format("fail to load default properties(\u52a0\u8f7d\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u5931\u8d25) %s cause by %s", propPath, e.getMessage()));
        }
        try {
            File confFile;
            File jarParent;
            URL classLocation = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (classLocation.toString().endsWith(JAR_SUFFIX) && null != (jarParent = new File(classLocation.getPath()).getParentFile().getParentFile()) && (confFile = new File(jarParent, propPath)).isFile()) {
                ConfigUtils.loadProperties(confFile.toURI().toURL(), props);
                loadedFiles.add(confFile);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (envVar != null && !envVar.isEmpty()) {
                String cf = System.getProperty(envVar);
                if (null != cf && !cf.isEmpty()) {
                    File envFile = new File(cf, propFile);
                    if (!loadedFiles.contains(envFile)) {
                        ConfigUtils.loadProperties(envFile.toURI().toURL(), props);
                        loadedFiles.add(envFile);
                    }
                } else {
                    ConfigUtils.log("not defined environment variable '%s'", envVar);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            File propInUserDir = new File(System.getProperty("user.dir"), propPath);
            if (propInUserDir.isFile() && !loadedFiles.contains(propInUserDir)) {
                ConfigUtils.loadProperties(propInUserDir.toURI().toURL(), props);
                loadedFiles.add(propInUserDir);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (showProp) {
            props.list(System.out);
        }
        return props;
    }

    public static Properties loadPropertiesInUserHome(String propPath) {
        Properties props = new Properties();
        try {
            File propInUserHome = new File(System.getProperty("user.home"), propPath);
            if (propInUserHome.isFile()) {
                ConfigUtils.loadProperties(propInUserHome.toURI().toURL(), props);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    public static void storePropertiesInUserHome(Properties properties, String propertiesFile) throws IOException {
        if (null == properties) {
            throw new NullPointerException();
        }
        if (null == propertiesFile || propertiesFile.isEmpty()) {
            throw new IllegalArgumentException("propertiesFile must not be empty or null");
        }
        File propInUserHome = new File(System.getProperty("user.home"), propertiesFile);
        File parent = propInUserHome.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        properties.store(new FileWriter(propInUserHome), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(URL url, Properties props) throws IOException {
        if (null != url) {
            try (InputStream is = null;){
                is = url.openStream();
                props.load(new InputStreamReader(is, "UTF-8"));
                ConfigUtils.log("Load properties from %s", url.toString());
            }
        }
    }

    private static void log(String format, Object ... args) {
        System.out.printf("[%s:%d]%s\n", ConfigUtils.class.getSimpleName(), Thread.currentThread().getStackTrace()[2].getLineNumber(), String.format(format, args));
    }
}

