/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.gdface.utils.Assert;
import net.gdface.utils.Delegator;

public class InterfaceDecorator<I, T>
implements InvocationHandler,
Delegator<T> {
    private final Class<I> interfaceClass;
    protected final T delegate;

    public InterfaceDecorator(Class<I> interfaceClass, T delegate) {
        Assert.notNull(interfaceClass, "interfaceClass");
        Assert.notNull(delegate, "delegate");
        Assert.isTrue(interfaceClass.isInterface() && interfaceClass.isInstance(delegate), "interfaceClass.isInstance(delegate)", "delegate must implement interfaceClass ");
        this.interfaceClass = interfaceClass;
        this.delegate = delegate;
    }

    public InterfaceDecorator(T delegate) {
        Assert.notNull(delegate, "delegate");
        if (delegate.getClass().getInterfaces().length != 1) {
            throw new IllegalArgumentException(String.format("can't determines interface class from %s", delegate.getClass().getName()));
        }
        this.interfaceClass = delegate.getClass().getInterfaces()[0];
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke(this.delegate, args);
    }

    public final Class<I> getInterfaceClass() {
        return this.interfaceClass;
    }

    public final I proxyInstance() {
        return this.interfaceClass.cast(Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass}, (InvocationHandler)this));
    }

    @Override
    public T delegate() {
        return this.delegate;
    }
}

