/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.gdface.utils.Assert;
import org.apache.bytecode.ChainedParamReader;

public class ParameterNames {
    private final Map<Class<?>, ChainedParamReader> readers = new HashMap();
    private final Class<?> clazz;
    private boolean returnFakeNameIfFail = true;

    public ParameterNames setReturnFakeNameIfFail(boolean returnFakeNameIfFail) {
        this.returnFakeNameIfFail = returnFakeNameIfFail;
        return this;
    }

    public ParameterNames(Class<?> clazz) {
        this.clazz = clazz;
        if (null != clazz) {
            try {
                Class<?> c = clazz;
                do {
                    this.readers.put(c, new ChainedParamReader(c));
                } while (null != (c = c.getSuperclass()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final String[] getParameterNames(ChainedParamReader reader, Member member) {
        int paramCount;
        String[] parameterNames = null;
        if (member instanceof Method) {
            parameterNames = reader.getParameterNames((Method)member);
            paramCount = ((Method)member).getParameterTypes().length;
        } else if (member instanceof Constructor) {
            parameterNames = reader.getParameterNames((Constructor)member);
            paramCount = ((Constructor)member).getParameterTypes().length;
        } else {
            throw new IllegalArgumentException("member type must be Method or Constructor");
        }
        if (this.returnFakeNameIfFail && null == parameterNames) {
            parameterNames = new String[paramCount];
            for (int i = 0; i < parameterNames.length; ++i) {
                parameterNames[i] = String.format("arg%d", i);
            }
        }
        return parameterNames;
    }

    public final String[] getParameterNames(Member member) {
        if (null == this.clazz) {
            return null;
        }
        Assert.notNull(member, "member");
        Class<?> declaringClass = member.getDeclaringClass();
        ChainedParamReader reader = this.readers.get(declaringClass);
        if (null == reader) {
            throw new IllegalArgumentException(String.format("%s is not member of %s", member.toString(), declaringClass.getName()));
        }
        return this.getParameterNames(reader, member);
    }

    public final String[] getParameterNames(String name, Class<?>[] parameterTypes) throws NoSuchMethodException {
        if (null == this.clazz) {
            return null;
        }
        try {
            Member member = null == name ? this.clazz.getConstructor(parameterTypes) : this.clazz.getMethod(name, parameterTypes);
            return this.getParameterNames(member);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public final String[] getParameterNamesUnchecked(String name, Class<?>[] parameterTypes) {
        try {
            return this.getParameterNames(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

