/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ResourcePool<R> {
    protected final LinkedBlockingQueue<R> queue = new LinkedBlockingQueue();
    private final ThreadLocal<R> tlsResource = new ThreadLocal();
    private final ThreadLocal<AtomicInteger> threadNestCount = new ThreadLocal();
    private final boolean nestable = this.isNestable();

    protected ResourcePool() {
    }

    public ResourcePool(Collection<R> resources) {
        for (R r : resources) {
            if (null == r) {
                throw new IllegalArgumentException("resources contains null element");
            }
            this.queue.add(r);
        }
    }

    @SafeVarargs
    public ResourcePool(R ... resources) {
        this((Collection<R>)Arrays.asList(resources));
    }

    private R getResource() throws InterruptedException {
        R r;
        if (null != this.tlsResource.get()) {
            throw new IllegalStateException("INVALID tlsResource state");
        }
        if (this.queue.isEmpty() && null != (r = this.newResource())) {
            this.queue.offer(r);
        }
        r = this.open(this.queue.take());
        this.tlsResource.set(r);
        return r;
    }

    private void recycleResource() {
        R r = this.tlsResource.get();
        if (null == r) {
            throw new IllegalStateException("INVALID tlsResource while recycle");
        }
        this.queue.offer(this.close(r));
        this.tlsResource.remove();
    }

    public final R applyChecked() throws InterruptedException {
        if (this.nestable) {
            AtomicInteger count = this.threadNestCount.get();
            if (null == count) {
                count = new AtomicInteger(1);
                this.threadNestCount.set(count);
                return this.getResource();
            }
            if (null == this.tlsResource.get()) {
                throw new IllegalStateException("INVALID tlsResource");
            }
            count.incrementAndGet();
            return this.tlsResource.get();
        }
        return this.getResource();
    }

    public final R apply() {
        try {
            return this.applyChecked();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public final void free() {
        if (this.nestable) {
            AtomicInteger count = this.threadNestCount.get();
            if (null == count) {
                throw new IllegalStateException("INVALID nestCount");
            }
            if (0 == count.decrementAndGet()) {
                this.threadNestCount.remove();
                this.recycleResource();
            }
        } else {
            this.recycleResource();
        }
    }

    protected boolean isNestable() {
        return false;
    }

    protected R newResource() {
        return null;
    }

    protected R open(R resource) {
        return resource;
    }

    protected R close(R resource) {
        return resource;
    }

    public static class IntResourcePool
    extends ResourcePool<Integer> {
        public IntResourcePool(Collection<Integer> resources) {
            super(resources);
        }

        public IntResourcePool(Integer ... resources) {
            super(resources);
        }

        public IntResourcePool(int capacity) {
            this(capacity, 0, 1);
        }

        public IntResourcePool(int capacity, int start, int step) {
            this((Collection<Integer>)IntResourcePool.createList(capacity, start, step));
        }

        private static List<Integer> createList(int capacity, int start, int step) {
            if (capacity <= 0) {
                throw new IllegalArgumentException(String.format("INVALID capacity:%d", capacity));
            }
            if (step <= 0) {
                throw new IllegalArgumentException("INVALID step:0");
            }
            ArrayList<Integer> list = new ArrayList<Integer>(capacity);
            int endNu = start + capacity * step;
            for (int i = start; i < endNu; i += step) {
                list.add(i);
            }
            return list;
        }
    }
}

