/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.PrintStream;

public class SampleLog {
    private static final String DELIM_STR = "{}";
    private static final Object[] EMPTY_ARGS = new Object[0];

    private static void log(PrintStream printStream, int level, String format, Object ... args) {
        if (null == printStream || null == format) {
            return;
        }
        if (null == args) {
            args = EMPTY_ARGS;
        }
        StringBuilder buffer = new StringBuilder(format.length() + 64);
        int beginIndex = 0;
        int endIndex = 0;
        int count = 0;
        while ((endIndex = format.indexOf(DELIM_STR, beginIndex)) >= 0) {
            buffer.append(format.substring(beginIndex, endIndex));
            try {
                buffer.append(args[count++]);
            }
            catch (IndexOutOfBoundsException e) {
                buffer.append("null");
            }
            beginIndex = endIndex + DELIM_STR.length();
        }
        buffer.append(format.substring(beginIndex, format.length()));
        Thread currentThread = Thread.currentThread();
        StackTraceElement stackTrace = currentThread.getStackTrace()[level];
        printStream.printf("[%s] (%s:%d) %s\n", currentThread.getName(), stackTrace.getFileName(), stackTrace.getLineNumber(), buffer.toString());
    }

    public static void log(PrintStream printStream, String format, Object ... args) {
        SampleLog.log(printStream, 3, format, args);
    }

    public static void log(String format, Object ... args) {
        SampleLog.log(System.out, 3, format, args);
    }
}

