/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.client;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import gu.dtalk.Ack;
import gu.dtalk.BaseItem;
import gu.dtalk.BaseOption;
import gu.dtalk.CmdItem;
import gu.dtalk.CommonUtils;
import gu.dtalk.ItemType;
import gu.dtalk.MenuItem;
import gu.dtalk.client.ConnectorAdapter;
import gu.dtalk.client.RenderEngine;
import gu.dtalk.client.TextMessageAdapter;
import gu.simplemq.Channel;
import gu.simplemq.IMQConnParameterSupplier;
import gu.simplemq.IMessageAdapter;
import gu.simplemq.IMessageQueueConfigManager;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.IPublisher;
import gu.simplemq.ISubscriber;
import gu.simplemq.MessageQueueFactorys;
import gu.simplemq.MessageQueueType;
import gu.simplemq.exceptions.SmqNotFoundConnectionException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Scanner;
import net.gdface.utils.BinaryUtils;
import net.gdface.utils.NetworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseConsole {
    protected static final Logger logger = LoggerFactory.getLogger(BaseConsole.class);
    private IMessageQueueFactory factory;
    final ISubscriber subscriber;
    final IPublisher publisher;
    protected String reqChannel = null;
    protected final byte[] temminalMac;
    private final String ackchname;
    protected final String connchname;
    private final RenderEngine renderEngine = new RenderEngine();
    private final Channel<JSONObject> ackChannel;
    private boolean stackTrace = false;

    public BaseConsole(String devmac, IMessageQueueFactory factory) {
        this.factory = (IMessageQueueFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory is null");
        this.temminalMac = BaseConsole.getSelfMac(factory.getHostAndPort());
        this.subscriber = factory.getSubscriber();
        this.publisher = factory.getPublisher();
        System.out.printf("TERMINAL MAC address: %s\n", NetworkUtil.formatMac((byte[])this.temminalMac, (String)":"));
        this.ackchname = CommonUtils.getAckChannel((byte[])this.temminalMac);
        ConnectorAdapter msgAdapter = new ConnectorAdapter().setOnValidPwd(new Predicate<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean apply(String input) {
                Channel channel = BaseConsole.this.ackChannel;
                synchronized (channel) {
                    BaseConsole.this.reqChannel = input;
                    BaseConsole.this.ackChannel.setAdapter((IMessageAdapter)BaseConsole.this.renderEngine);
                    BaseConsole.this.ackChannel.notifyAll();
                }
                return false;
            }
        });
        this.ackChannel = new Channel(this.ackchname, JSONObject.class).setAdapter((IMessageAdapter)msgAdapter);
        if (Strings.isNullOrEmpty((String)devmac)) {
            devmac = BinaryUtils.toHex((byte[])this.temminalMac);
            System.out.println("use local MAC for target DEVICE");
        }
        devmac = devmac.replaceAll("[^\\w]", "");
        System.out.printf("DEVICE MAC address: %s\n", devmac);
        this.connchname = CommonUtils.getConnChannel((String)devmac);
    }

    protected static byte[] getSelfMac(HostAndPort hostAndPort) {
        try {
            String host = hostAndPort.getHost();
            int port = hostAndPort.getPort();
            if (InetAddress.getByName(host).isLoopbackAddress()) {
                return NetworkUtil.getCurrentMac((String)"www.baidu.com:80");
            }
            return NetworkUtil.getCurrentMac((String)host, (int)port);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void connect() {
        this.subscriber.register(new Channel[]{this.ackChannel});
    }

    protected static String scanLine(Predicate<String> validate) {
        Scanner scaner = new Scanner(System.in);
        return BaseConsole.scanLine(validate, scaner);
    }

    private static String scanLine(Predicate<String> validate, Scanner scaner) {
        scaner.reset();
        scaner.useDelimiter("\r?\n");
        while (scaner.hasNextLine()) {
            String str = scaner.next();
            if (str.isEmpty()) {
                return "";
            }
            try {
                if (!validate.apply((Object)str)) continue;
                return str;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return "";
    }

    protected static String inputMac() {
        System.out.println("Input MAC address of Device,such as '00:00:7f:2a:39:4A' or '00e8992730FF':(input empty string if target device demo running on localhost)");
        return BaseConsole.scanLine(new Predicate<String>(){

            public boolean apply(String input) {
                String mac = BaseConsole.parseMac(input);
                if (!mac.isEmpty()) {
                    return true;
                }
                System.out.println("ERROR:Invalid mac adress");
                return false;
            }
        });
    }

    private void waitResp(long timestamp) {
        int waitCount = 100;
        TextMessageAdapter adapter = (TextMessageAdapter)this.ackChannel.getAdapter();
        while (adapter.getLastResp() < timestamp && waitCount > 0) {
            try {
                Thread.sleep(100L);
                --waitCount;
            }
            catch (InterruptedException e) {
                System.exit(-1);
            }
        }
        if (waitCount == 0) {
            System.out.println("TIMEOUT for response");
            System.exit(-1);
        }
    }

    private JSONObject makeItemJSON(String path) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0);
        JSONObject json = new JSONObject();
        if (path.equals("/")) {
            json.fluentPut("path", (Object)path).fluentPut("catalog", (Object)ItemType.MENU);
        } else {
            BaseItem item;
            BaseItem currentLevel = (BaseItem)Preconditions.checkNotNull((Object)this.renderEngine.getCurrentLevel(), (Object)"currentLevel is null");
            if (".".equals(path)) {
                item = currentLevel;
                path = item.getPath();
            } else {
                item = (BaseItem)Preconditions.checkNotNull((Object)currentLevel.getChildByPath(path), (String)"NOT FOUND item %s", (Object)path);
            }
            json.fluentPut("path", (Object)path).fluentPut("catalog", (Object)item.getCatalog());
        }
        return json;
    }

    protected <T> boolean syncPublish(Channel<T> channel, T json) {
        try {
            long timestamp = System.currentTimeMillis();
            this.publisher.publish(channel, json);
            this.waitResp(timestamp);
            return true;
        }
        catch (Exception e) {
            this.showError(e);
            System.exit(0);
            return false;
        }
    }

    private boolean syncPublishReq(Object json) {
        Channel reqCh = new Channel((String)Preconditions.checkNotNull((Object)this.reqChannel), Object.class);
        return this.syncPublish(reqCh, json);
    }

    private boolean inputOption(Scanner scaner, final JSONObject json) {
        Preconditions.checkArgument((json != null && ItemType.OPTION == json.getObject("catalog", ItemType.class) ? 1 : 0) != 0);
        BaseItem item = this.renderEngine.getCurrentLevel().getChildByPath(json.getString("path"));
        Preconditions.checkArgument((boolean)(item instanceof BaseOption));
        BaseOption option = (BaseOption)item;
        String desc = Strings.isNullOrEmpty((String)option.getDescription()) ? "" : "(" + option.getDescription() + ")";
        System.out.printf("INPUT VALUE for %s(%s)%s(input empty for skip):", option.getUiName(), option.getName(), desc);
        String value = BaseConsole.scanLine(new Predicate<String>(){

            public boolean apply(String input) {
                if (CommonUtils.isImage((JSONObject)json, (BaseItem)BaseConsole.this.renderEngine.getCurrentLevel())) {
                    try {
                        json.fluentPut("value", (Object)BinaryUtils.getBytesNotEmpty((Object)new File(input)));
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                } else {
                    json.fluentPut("value", (Object)input);
                }
                return true;
            }
        }, scaner);
        return !value.isEmpty();
    }

    private boolean inputCmd(Scanner scaner, JSONObject json) {
        Preconditions.checkArgument((json != null && ItemType.CMD == json.getObject("catalog", ItemType.class) ? 1 : 0) != 0);
        BaseItem item = this.renderEngine.getCurrentLevel().getChildByPath(json.getString("path"));
        Preconditions.checkArgument((boolean)(item instanceof CmdItem));
        CmdItem cmd = (CmdItem)item;
        block0: for (BaseOption param : cmd.getParameters()) {
            JSONObject optjson = this.makeItemJSON(param.getPath());
            while (this.inputOption(scaner, optjson)) {
                if (this.syncPublishReq(optjson)) {
                    Preconditions.checkState((boolean)CommonUtils.isAck((Object)this.renderEngine.getLastRespObj()));
                    Ack.Status status = (Ack.Status)((JSONObject)this.renderEngine.getLastRespObj()).getObject("status", Ack.Status.class);
                    if (status == Ack.Status.OK) continue block0;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cmdInteractive() {
        if (!this.syncPublishReq(this.makeItemJSON("/"))) {
            return;
        }
        try (Scanner scaner = new Scanner(System.in);){
            while (scaner.hasNextLine()) {
                String str = scaner.next();
                if (str.isEmpty()) continue;
                try {
                    JSONObject json = this.makeItemJSON(str);
                    switch ((ItemType)json.getObject("catalog", ItemType.class)) {
                        case MENU: {
                            this.syncPublishReq(json);
                            break;
                        }
                        case OPTION: {
                            Ack<?> ack = null;
                            while (this.inputOption(scaner, json)) {
                                this.syncPublishReq(json);
                                ack = this.renderEngine.getLastAck();
                                if (ack != null && !Ack.Status.OK.equals((Object)ack.getStatus())) continue;
                            }
                            this.syncPublishReq(this.makeItemJSON(this.renderEngine.getCurrentLevel().getPath()));
                            break;
                        }
                        case CMD: {
                            MenuItem lastLevel = this.renderEngine.getCurrentLevel();
                            if (!this.inputCmd(scaner, json)) break;
                            this.syncPublishReq(json);
                            if (!CommonUtils.isQuit((JSONObject)json, (BaseItem)lastLevel)) break;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
    }

    protected static String parseMac(String input) {
        if ((input = ((String)MoreObjects.firstNonNull((Object)input, (Object)"")).trim()).matches("([\\da-fA-F]{2}:?){6}")) {
            return input.replace(":", "").toLowerCase();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        block19: {
            try {
                this.connect();
                if (!this.authorize()) break block19;
                if (this.ackChannel.getAdapter() != this.renderEngine) {
                    Channel<JSONObject> channel = this.ackChannel;
                    synchronized (channel) {
                        this.ackChannel.wait(5000L);
                    }
                }
                this.cmdInteractive();
            }
            catch (InterruptedException e) {
                System.out.println("TIMEOUT for response");
                System.exit(-1);
            }
            catch (Exception e) {
                this.showError(e);
                return;
            }
            finally {
                try {
                    this.factory.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void showError(Throwable e) {
        if (this.stackTrace) {
            logger.error(e.getMessage(), e);
        } else {
            System.out.println(e.getMessage());
        }
    }

    protected abstract boolean authorize();

    public BaseConsole setStackTrace(boolean stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    public static <T extends BaseConsole> T makeConsole(Class<T> targetClass, String devmac, IMessageQueueConfigManager manager) throws SmqNotFoundConnectionException {
        IMQConnParameterSupplier config = ((IMessageQueueConfigManager)Preconditions.checkNotNull((Object)manager, (Object)"manager is null")).lookupMessageQueueConnect(null);
        logger.info("use config={}", (Object)config);
        IMessageQueueFactory factory = MessageQueueFactorys.getFactory((MessageQueueType)config.getImplType()).init(config.getMQConnParameters()).asDefaultFactory();
        try {
            return (T)((BaseConsole)targetClass.getConstructor(String.class, IMessageQueueFactory.class).newInstance(devmac, factory));
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

