/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.client;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.base.Preconditions;
import gu.dtalk.Ack;
import gu.dtalk.BaseItem;
import gu.dtalk.CommonUtils;
import gu.dtalk.ItemType;
import gu.dtalk.MenuItem;
import gu.dtalk.client.TextMessageAdapter;
import gu.simplemq.exceptions.SmqUnsubscribeException;
import java.util.Map;

public class RenderEngine
extends TextMessageAdapter<JSONObject> {
    private String currentPath;
    private MenuItem root;
    private Ack<?> lastAck;

    public Ack<?> getLastAck() {
        return this.lastAck;
    }

    @Override
    public void onSubscribe(JSONObject resp) throws SmqUnsubscribeException {
        super.onSubscribe(resp);
        this.lastAck = null;
        if (CommonUtils.isAck((Object)resp)) {
            Ack ack = (Ack)TypeUtils.castToJavaBean((Object)resp, Ack.class);
            this.lastAck = (Ack)TypeUtils.castToJavaBean((Object)resp, Ack.class);
            this.render.rendeAck(ack, true);
        } else if (CommonUtils.isItem((Object)resp)) {
            BaseItem item = ItemType.parseItem((Map)resp);
            if (item instanceof MenuItem) {
                MenuItem menu = (MenuItem)item;
                this.currentPath = menu.getPath();
                if (CommonUtils.isRoot((JSONObject)resp)) {
                    this.root = menu;
                } else {
                    Preconditions.checkState((this.root != null ? 1 : 0) != 0, (Object)" root menu is uninitialized");
                    this.root.getChildByPath(this.currentPath).getParent().updateChild((BaseItem)menu);
                }
                this.render.rendeItem(menu);
            } else {
                System.out.printf("UNSUPPORTED ITEM RENDE TYPE:%s\n", item.getCatalog());
            }
        } else {
            System.out.printf("UNKNOW TYPE:%s\n", resp.toString());
        }
    }

    public MenuItem getCurrentLevel() {
        return ((MenuItem)Preconditions.checkNotNull((Object)this.root)).findMenu(this.currentPath);
    }

    public MenuItem getRoot() {
        return this.root;
    }

    public RenderEngine reset() {
        this.currentPath = null;
        this.root = null;
        return this;
    }

    public void paint() {
        this.render.rendeItem(this.getCurrentLevel());
    }
}

