/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import gu.dtalk.ConnectReq;
import gu.dtalk.client.BaseConsole;
import gu.dtalk.client.SampleConsoleConstants;
import gu.simplemq.Channel;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.MessageQueueConfigManagers;
import gu.simplemq.MessageQueueType;
import gu.simplemq.exceptions.SmqNotFoundConnectionException;
import net.gdface.cli.BaseAppConfig;
import net.gdface.utils.BinaryUtils;

public class SampleConsole
extends BaseConsole
implements SampleConsoleConstants {
    public SampleConsole(String devmac, IMessageQueueFactory factory) throws SmqNotFoundConnectionException {
        super(devmac, factory);
    }

    @Override
    protected boolean authorize() {
        System.out.println("Input password  of Device,default password is last 4 character of device MAC address(lowercase):");
        ConnectReq req = new ConnectReq();
        req.mac = BinaryUtils.toHex((byte[])this.temminalMac);
        Channel conch = new Channel(this.connchname, ConnectReq.class);
        String pwd = null;
        while (this.reqChannel == null && !(pwd = SampleConsole.scanLine((Predicate<String>)Predicates.alwaysTrue())).isEmpty()) {
            req.pwd = BinaryUtils.getMD5String((byte[])pwd.getBytes());
            this.syncPublish(conch, req);
        }
        if (this.reqChannel != null) {
            System.out.println("PASSWORD validate passed");
            return true;
        }
        return false;
    }

    static void run(BaseAppConfig config, String[] args) {
        config.parseCommandLine(args);
        MessageQueueType implType = (MessageQueueType)Preconditions.checkNotNull((Object)((MessageQueueType)config.getConstant("IMPL_TYPE")), (String)"NOT DEFINED %s", (Object)"IMPL_TYPE");
        String devmac = (String)config.valueOf("mac");
        boolean trace = config.isTrace();
        System.out.printf("Text terminal for Redis %s Talk is starting(\u8bbe\u5907(%s)\u4ea4\u4e92\u5b57\u7b26\u7ec8\u7aef\u542f\u52a8)\n", implType, implType);
        if (Strings.isNullOrEmpty((String)devmac)) {
            devmac = SampleConsole.inputMac();
        }
        try {
            SampleConsole client = BaseConsole.makeConsole(SampleConsole.class, devmac, MessageQueueConfigManagers.getManager((MessageQueueType)implType));
            client.setStackTrace(trace).start();
        }
        catch (SmqNotFoundConnectionException e) {
            if (trace) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            System.out.println(e.getMessage());
        }
    }
}

