/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import gu.dtalk.OptionType;
import gu.dtalk.activemq.ActivemqContext;
import gu.dtalk.activemq.DefaultCustomActivemqConfigProvider;
import gu.dtalk.client.SampleConsole;
import gu.dtalk.client.SampleConsoleConstants;
import gu.simplemq.MessageQueueType;
import gu.simplemq.mqtt.MqttConstants;
import gu.simplemq.utils.MQProperties;
import gu.simplemq.utils.URISupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.gdface.cli.BaseAppConfig;
import net.gdface.utils.ConditionChecks;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SampleConsoleActivemqConfig
extends BaseAppConfig
implements SampleConsoleConstants,
MqttConstants {
    private static final HashMap<String, Object> CONSTANTS = new HashMap<String, Object>(){
        {
            this.put("IMPL_TYPE", MessageQueueType.ACTIVEMQ);
        }
    };
    private final MQProperties activemqProperties = ActivemqContext.HELPER.initParameters(null);
    private String mac;

    private SampleConsoleActivemqConfig() {
        super(true);
        this.options.addOption(Option.builder().longOpt("host").desc("activemq host name,default: " + ActivemqContext.CONSTP_ROVIDER.getDefaultHost()).numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("port").desc("activemq port number,default: " + ActivemqContext.CONSTP_ROVIDER.getDefaultPort()).numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder().longOpt("auth").desc("activemq password,default:empty").numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("uri").desc("uri for redis,default:null").numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("timout").desc("redis timeout,default:2000 ms.").numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder().longOpt("mac").desc("MAC addres(hex)for target device,such as d0:17:c2:d0:3f:bf,default: self mac address").numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("mqtt").desc("use MQTT protocol for publish/subscribe service, and the optional argument define URI or HOST:PORT or HOST or PORT format for activemq mqtt service location,such as '--mqtt mqtt://localhost:1883' OR '--mqtt  127.0.0.1:1883' OR ' --mqtt 127.0.0.1' OR ' --mqtt 1883' ,if no argument follow '--mqtt' ,  use default: same with ${uri} option or ${host}:${port}").optionalArg(true).numberOfArgs(1).build());
        this.defaultValue.setProperty("host", this.activemqProperties.get((Object)"host"));
        this.defaultValue.setProperty("port", this.activemqProperties.get((Object)"port"));
        this.defaultValue.setProperty("auth", this.activemqProperties.get((Object)"password"));
        this.defaultValue.setProperty("uri", this.activemqProperties.get((Object)"uri"));
        this.defaultValue.setProperty("timout", this.activemqProperties.get((Object)"timeoutMills"));
        this.defaultValue.setProperty("mac", (Object)"");
    }

    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        super.loadConfig(options, cmd);
        if (this.hasProperty("host")) {
            this.activemqProperties.setProperty("host", (String)this.getProperty("host"));
        }
        if (this.hasProperty("port")) {
            this.activemqProperties.setProperty("port", (String)this.getProperty("port"));
        }
        if (this.hasProperty("auth")) {
            this.activemqProperties.setProperty("password", (String)this.getProperty("auth"));
        }
        if (this.hasProperty("uri")) {
            this.activemqProperties.setProperty("uri", (String)this.getProperty("uri"));
        }
        if (this.hasProperty("timout")) {
            this.activemqProperties.setProperty("timeoutMills", (String)this.getProperty("timout"));
        }
        this.mac = (String)this.getProperty("mac");
        if (!Strings.isNullOrEmpty((String)this.mac)) {
            ConditionChecks.checkTrue((boolean)OptionType.MAC.strValidator.apply((Object)this.mac), ParseException.class, (String)"INVALID MAC address %s", (Object)this.mac);
            this.mac = this.mac.replaceAll("[:-]", "");
        }
        this.parseMQTTOption();
    }

    private void parseMQTTOption() throws ParseException {
        if (this.hasProperty("mqtt")) {
            Object v = this.getProperty("mqtt");
            this.activemqProperties.setProperty("pubsub.mqtt", "true");
            if (v instanceof String) {
                String value = (String)v;
                try {
                    int port = Integer.parseInt(value);
                    Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"INVALID option %s:%s,as port ,>0 required", (Object)"mqtt", (int)port);
                    this.activemqProperties.setProperty("pubsub.uri", String.format("mqtt://%s:%d", ActivemqContext.CONSTP_ROVIDER.getDefaultHost(), port));
                }
                catch (NumberFormatException e) {
                    HostAndPort hostAndPort;
                    try {
                        hostAndPort = HostAndPort.fromString((String)value).withDefaultPort(1883);
                    }
                    catch (IllegalArgumentException e2) {
                        try {
                            URI u = new URI(value);
                            URI r = URISupport.changeScheme((URI)u, (String)"mqtt");
                            this.activemqProperties.setProperty("pubsub.uri", r.toString());
                            return;
                        }
                        catch (URISyntaxException e1) {
                            throw new ParseException(String.format("INVALID value %s for option %s", value, "mqtt"));
                        }
                    }
                    this.activemqProperties.setProperty("pubsub.uri", String.format("mqtt://%s:%d", hostAndPort.getHost(), hostAndPort.getPort()));
                    return;
                }
            }
            Preconditions.checkState((boolean)Boolean.TRUE.equals(v), (String)"INVALID VALUE TYPE FOR %s=%s", (Object)"mqtt", (Object)v);
            this.activemqProperties.setProperty("pubsub.uri", "mqtt://localhost:1883");
        }
    }

    public MQProperties getActivemqParameters() {
        return this.activemqProperties;
    }

    public String getMac() {
        return this.mac;
    }

    protected String getAppName() {
        return SampleConsole.class.getSimpleName();
    }

    protected String getHeader() {
        return "Text terminal for Dtalk Device(Dtalk\u8bbe\u5907\u4ea4\u4e92\u5b57\u7b26\u7ec8\u7aef)";
    }

    protected void doAfterParse() {
        DefaultCustomActivemqConfigProvider.INIT_PROPERTIES.init((Map)this.activemqProperties);
    }

    protected Map<String, Object> doGetConstants() {
        return CONSTANTS;
    }

    public static void main(String[] args) {
        SampleConsole.run(new SampleConsoleActivemqConfig(), args);
    }
}

