/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import gu.dtalk.BaseBinary;
import gu.dtalk.OptionType;
import net.gdface.image.BaseLazyImage;
import net.gdface.image.ImageErrorException;
import net.gdface.utils.BinaryUtils;
import net.gdface.utils.Judge;

public class ImageOption
extends BaseBinary {
    private volatile boolean updated = false;
    private BaseLazyImage image;

    @Override
    public OptionType getType() {
        return OptionType.IMAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageOption setValue(byte[] value) {
        ImageOption imageOption = this;
        synchronized (imageOption) {
            super.setValue(value);
            this.updated = false;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseLazyImage imageObj() throws ImageErrorException {
        if (Judge.isEmpty((byte[])this.getValue())) {
            return null;
        }
        if (!this.updated) {
            ImageOption imageOption = this;
            synchronized (imageOption) {
                if (!this.updated) {
                    this.image = BaseLazyImage.getLazyImageFactory().create((byte[])this.getValue());
                    this.updated = true;
                }
            }
        }
        return this.image;
    }

    public BaseLazyImage imageObjUncheck() {
        try {
            return this.imageObj();
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public int getWidth() {
        try {
            return this.imageObj().getWidth();
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public int getHeight() {
        try {
            return this.imageObj().getHeight();
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public String getSuffix() throws ImageErrorException {
        try {
            return this.imageObj().getSuffix();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public ImageOption asValue(String input) {
        try {
            this.setValue(BinaryUtils.getBytes(input));
            return this;
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public <T> ImageOption asValue(T input) {
        super.asDefaultValue(input);
        return this;
    }

    public ImageOption asDefaultValue(String input) {
        try {
            this.setDefaultValue(BinaryUtils.getBytes(input));
            return this;
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public <T> ImageOption asDefaultValue(T input) {
        super.asDefaultValue(input);
        return this;
    }

    public <T> ImageOption asValue(BaseLazyImage input) {
        this.setValue(input.wirteJPEGBytes());
        this.image = input;
        return this;
    }

    public <T> ImageOption asDefaultValue(BaseLazyImage input) {
        this.setDefaultValue(input.wirteJPEGBytes());
        this.image = input;
        return this;
    }

    @Override
    public String contentOfValue() {
        try {
            BaseLazyImage img = this.imageObj();
            if (img != null) {
                return String.format("%s(%dx%d),size=%d", img.getSuffix(), img.getWidth(), img.getHeight(), ((byte[])this.getValue()).length);
            }
        }
        catch (ImageErrorException e) {
            return MoreObjects.firstNonNull(e.getMessage(), "NOT IMAGE");
        }
        return super.contentOfValue();
    }
}

