/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import gu.dtalk.BaseBinary;
import gu.dtalk.OptionType;
import java.net.NetworkInterface;
import net.gdface.utils.NetworkUtil;

public class MACOption
extends BaseBinary {
    public static final Predicate<byte[]> VALIDATOR = new Predicate<byte[]>(){

        @Override
        public boolean apply(byte[] input) {
            return input != null && input.length == 6;
        }
    };

    public MACOption() {
        this.setValidator(VALIDATOR);
    }

    @Override
    public OptionType getType() {
        return OptionType.MAC;
    }

    @Override
    public String contentOfValue() {
        if (this.getValue() == null) {
            return super.contentOfValue();
        }
        return NetworkUtil.formatMac((byte[])this.getValue(), ":");
    }

    public MACOption asValue(NetworkInterface input) {
        try {
            this.setValue(input.getHardwareAddress());
            return this;
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public MACOption asDefaultValue(NetworkInterface input) {
        try {
            this.setDefaultValue(input.getHardwareAddress());
            return this;
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

