/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.activemq;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.net.HostAndPort;
import gu.dtalk.activemq.ActivemqConfigProvider;
import gu.dtalk.activemq.ActivemqContext;
import gu.dtalk.activemq.DefaultCloudActivemqConfigProvider;
import gu.dtalk.activemq.DefaultCustomActivemqConfigProvider;
import gu.dtalk.activemq.DefaultLocalActivemqConfigProvider;
import gu.dtalk.activemq.DefaultLocalhostActivemqConfigProvider;
import gu.simplemq.IMQConnParameterSupplier;
import gu.simplemq.MQProperties;
import gu.simplemq.MessageQueueType;
import gu.simplemq.exceptions.SmqNotFoundConnectionException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;

public enum ActivemqConfigType implements IMQConnParameterSupplier
{
    CUSTOM(new DefaultCustomActivemqConfigProvider()),
    LAN(new DefaultLocalActivemqConfigProvider()),
    CLOUD(new DefaultCloudActivemqConfigProvider()),
    LOCALHOST(new DefaultLocalhostActivemqConfigProvider());

    private final ActivemqConfigProvider defImpl;
    private volatile ActivemqConfigProvider instance;
    private volatile MQProperties parameters;
    private volatile boolean connectable = false;
    private static volatile ActivemqConfigType activeConfigType;

    private ActivemqConfigType() {
        this(null);
    }

    private ActivemqConfigType(ActivemqConfigProvider defImpl) {
        this.defImpl = defImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivemqConfigProvider findConfigProvider() {
        if (this.instance == null) {
            ActivemqConfigType activemqConfigType = this;
            synchronized (activemqConfigType) {
                if (this.instance == null) {
                    ServiceLoader<ActivemqConfigProvider> providers = ServiceLoader.load(ActivemqConfigProvider.class);
                    Iterator<ActivemqConfigProvider> itor = providers.iterator();
                    Optional<ActivemqConfigProvider> find = Iterators.tryFind(itor, new Predicate<ActivemqConfigProvider>(){

                        @Override
                        public boolean apply(ActivemqConfigProvider input) {
                            return input.type() == ActivemqConfigType.this;
                        }
                    });
                    this.instance = find.isPresent() ? find.get() : this.defImpl;
                    MQProperties props = this.instance.getProperties();
                    String location = props.getLocationAsString();
                    if (location == null) {
                        this.instance = null;
                    }
                }
            }
        }
        return this.instance;
    }

    @Override
    public HostAndPort getHostAndPort() {
        return this.parameters.getHostAndPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MQProperties readParam() {
        if (this.parameters == null) {
            ActivemqConfigType activemqConfigType = this;
            synchronized (activemqConfigType) {
                ActivemqConfigProvider config;
                if (this.parameters == null && (config = this.findConfigProvider()) != null) {
                    this.parameters = config.getProperties();
                }
            }
        }
        return this.parameters;
    }

    @Override
    public Map<String, Object> getMQConnParameters() {
        MQProperties props = this.readParam();
        return props;
    }

    @Override
    public final MessageQueueType getImplType() {
        return MessageQueueType.ACTIVEMQ;
    }

    public synchronized void saveParam(Properties param) {
        ActivemqConfigProvider config = this.findConfigProvider();
        config.setProperties(param);
    }

    public static void resetActiveConfigType() {
        activeConfigType = null;
    }

    public synchronized boolean testConnect(Integer timeoutMills) {
        MQProperties props = this.readParam();
        this.connectable = false;
        if (props != null && !props.stringPropertyNames().isEmpty()) {
            try {
                this.connectable = ActivemqContext.HELPER.testConnect(props, timeoutMills);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.connectable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivemqConfigType lookupConnect(final Integer timeoutMills) throws SmqNotFoundConnectionException {
        if (activeConfigType != null) return activeConfigType;
        Class<ActivemqConfigType> clazz = ActivemqConfigType.class;
        synchronized (ActivemqConfigType.class) {
            if (activeConfigType != null) return activeConfigType;
            Thread[] threads = new Thread[ActivemqConfigType.values().length];
            int index = 0;
            for (final ActivemqConfigType type : ActivemqConfigType.values()) {
                threads[index] = new Thread(){

                    @Override
                    public void run() {
                        type.testConnect(timeoutMills);
                    }
                };
                threads[index].start();
                ++index;
            }
            try {
                for (int i = 0; i < threads.length; ++i) {
                    threads[i].join();
                    ActivemqConfigType type = ActivemqConfigType.values()[i];
                    if (!type.connectable) continue;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return type;
                }
                throw new SmqNotFoundConnectionException("NOT FOUND VALID ACTIVEMQ SERVER");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new SmqNotFoundConnectionException("NOT FOUND VALID ACTIVEMQ SERVER");
        }
    }

    public static ActivemqConfigType lookupConnectUnchecked(Integer timeoutMills) {
        try {
            return ActivemqConfigType.lookupConnect(timeoutMills);
        }
        catch (SmqNotFoundConnectionException e) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName()).append(":");
        buffer.append(this.name());
        MQProperties param = this.readParam();
        if (param == null) {
            buffer.append("(UNDEFINED)");
        } else {
            buffer.append("(").append(ActivemqContext.HELPER.getLocationlURI(param).toString()).append(")");
        }
        return buffer.toString();
    }

    static {
        activeConfigType = null;
    }
}

