/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.activemq;

import gu.dtalk.activemq.ActivemqConfigProvider;
import gu.dtalk.activemq.ActivemqContext;
import gu.simplemq.Constant;
import gu.simplemq.MQProperties;
import gu.simplemq.utils.URISupport;
import java.net.URI;
import java.util.Map;
import java.util.Properties;

public abstract class BaseActivemqConfigProvider
implements ActivemqConfigProvider,
Constant {
    protected static final String DEFAULT_AMQP_URI = "amqp://localhost:5672";

    protected abstract MQProperties selfProp();

    @Override
    public final MQProperties getProperties() {
        return ActivemqContext.HELPER.makeMQProperties(null).init(this.selfProp());
    }

    @Override
    public final void setProperties(Properties properties) {
        MQProperties self = this.selfProp();
        if (properties != null) {
            self.clear();
            self.putAll((Map<?, ?>)properties);
        }
    }

    @Override
    public final void setProperty(String name, String value) {
        this.selfProp().setProperty(name, value);
    }

    @Override
    public final String getProperty(String name) {
        return this.selfProp().getProperty(name);
    }

    @Override
    public final String getProperty(String name, String defaultValue) {
        return this.selfProp().getProperty(name, defaultValue);
    }

    protected static void initMqttURI(MQProperties props, int mqttPort) {
        URI mqttURI = URISupport.changePortUnchecked(props.getLocation(), mqttPort);
        mqttURI = URISupport.changeSchemeUnchecked(mqttURI, "mqtt");
        props.setProperty("pubsub.uri", mqttURI.toString());
        props.setProperty("pubsub.mqtt", Boolean.TRUE.toString());
    }
}

