/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.activemq;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import gu.dtalk.activemq.ActivemqConfigType;
import gu.dtalk.activemq.ActivemqContext;
import gu.dtalk.activemq.BaseActivemqConfigProvider;
import gu.simplemq.MQProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import net.gdface.utils.JcifsUtil;

public class DefaultLocalActivemqConfigProvider
extends BaseActivemqConfigProvider {
    private static final String REG_IPV4 = "^((?:(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d))$";
    public static final MQProperties INIT_PROPERTIES = ActivemqContext.HELPER.initParameters(null).initURI(DefaultLocalActivemqConfigProvider.makeLantalkURL("landtalkhost"));
    private static final LoadingCache<String, String> IP_CACHE;

    @Override
    public final ActivemqConfigType type() {
        return ActivemqConfigType.LAN;
    }

    @Override
    protected MQProperties selfProp() {
        MQProperties props = INIT_PROPERTIES;
        URI uri = ActivemqContext.HELPER.getLocation(props);
        if (!uri.getHost().matches(REG_IPV4)) {
            String host = IP_CACHE.getUnchecked(uri.getHost());
            URI u2 = DefaultLocalActivemqConfigProvider.changeHost(uri, host);
            props.initURI(u2);
        }
        return props;
    }

    private static URI changeHost(URI uri, String host) {
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), host, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static String makeLantalkURL(String landtalkhost) {
        try {
            String defaultLocation = ActivemqContext.CONST_PROVIDER.getDefaultMQLocation();
            URI uri = new URI(defaultLocation);
            return DefaultLocalActivemqConfigProvider.changeHost(uri, landtalkhost).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initLandtalkhost(String landtalkhost) {
        INIT_PROPERTIES.initURI(DefaultLocalActivemqConfigProvider.makeLantalkURL(Preconditions.checkNotNull(landtalkhost, "landtalkhost is null")));
    }

    static {
        DefaultLocalActivemqConfigProvider.initMqttURI(INIT_PROPERTIES, 1883);
        IP_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<String, String>(){

            @Override
            public String load(String landtalkhost) throws Exception {
                try {
                    return JcifsUtil.hostAddressOf(landtalkhost);
                }
                catch (UnknownHostException e) {
                    return landtalkhost;
                }
            }
        });
    }
}

