/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import gu.dtalk.OptionType;
import gu.dtalk.activemq.ActivemqContext;
import gu.dtalk.activemq.DefaultCustomActivemqConfigProvider;
import gu.dtalk.client.SampleConsole;
import gu.dtalk.client.SampleConsoleConstants;
import gu.simplemq.Constant;
import gu.simplemq.MQProperties;
import gu.simplemq.MessageQueueType;
import gu.simplemq.utils.URISupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.gdface.cli.BaseAppConfig;
import net.gdface.utils.ConditionChecks;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SampleConsoleActivemqConfig
extends BaseAppConfig
implements SampleConsoleConstants,
Constant {
    private static final HashMap<String, Object> CONSTANTS = new HashMap<String, Object>(){
        {
            this.put("IMPL_TYPE", MessageQueueType.ACTIVEMQ);
        }
    };
    private final MQProperties activemqProperties = ActivemqContext.HELPER.initParameters(null);
    private String mac;

    private SampleConsoleActivemqConfig() {
        super(true);
        this.options.addOption(Option.builder().longOpt("host").desc("activemq host name,default: " + ActivemqContext.CONST_PROVIDER.getDefaultHost()).numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("port").desc("activemq port number,default: " + ActivemqContext.CONST_PROVIDER.getDefaultPort()).numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder("u").longOpt("user").desc("activemq username,default:empty").numberOfArgs(1).build());
        this.options.addOption(Option.builder("a").longOpt("auth").desc("activemq password,default:empty").numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("uri").desc("uri for redis,default:null").numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("timout").desc("redis timeout,default:2000 ms.").numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder().longOpt("mac").desc("MAC addres(hex)for target device,such as d0:17:c2:d0:3f:bf,default: self mac address").numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("mqtt").desc("use MQTT protocol for publish/subscribe service, and the optional argument define URI or HOST:PORT or HOST or PORT format for activemq mqtt service location,such as '--mqtt mqtt://localhost:1883' OR '--mqtt  127.0.0.1:1883' OR ' --mqtt 127.0.0.1' OR ' --mqtt 1883' ,if no argument follow '--mqtt' ,  use default: same with ${uri} option or ${host}:${port}").optionalArg(true).numberOfArgs(1).build());
        this.defaultValue.setProperty("host", this.activemqProperties.get("host"));
        this.defaultValue.setProperty("port", this.activemqProperties.get("port"));
        this.defaultValue.setProperty("activemq username,default:empty", this.activemqProperties.get("username"));
        this.defaultValue.setProperty("auth", this.activemqProperties.get("password"));
        this.defaultValue.setProperty("uri", this.activemqProperties.get("uri"));
        this.defaultValue.setProperty("timout", this.activemqProperties.get("timeoutMills"));
        this.defaultValue.setProperty("mac", "");
    }

    @Override
    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        super.loadConfig(options, cmd);
        if (this.hasProperty("host")) {
            this.activemqProperties.setProperty("host", (String)this.getProperty("host"));
        }
        if (this.hasProperty("port")) {
            this.activemqProperties.setProperty("port", (String)this.getProperty("port"));
        }
        if (this.hasProperty("user")) {
            this.activemqProperties.setProperty("username", (String)this.getProperty("user"));
        }
        if (this.hasProperty("auth")) {
            this.activemqProperties.setProperty("password", (String)this.getProperty("auth"));
        }
        if (this.hasProperty("uri")) {
            this.activemqProperties.setProperty("uri", (String)this.getProperty("uri"));
        }
        if (this.hasProperty("timout")) {
            this.activemqProperties.setProperty("timeoutMills", (String)this.getProperty("timout"));
        }
        this.mac = (String)this.getProperty("mac");
        if (!Strings.isNullOrEmpty(this.mac)) {
            ConditionChecks.checkTrue(OptionType.MAC.strValidator.apply(this.mac), ParseException.class, "INVALID MAC address %s", (Object)this.mac);
            this.mac = this.mac.replaceAll("[:-]", "");
        }
        this.parseMQTTOption();
    }

    private void parseMQTTOption() throws ParseException {
        if (this.hasProperty("mqtt")) {
            Object v = this.getProperty("mqtt");
            this.activemqProperties.setProperty("pubsub.mqtt", "true");
            if (v instanceof String) {
                String value = (String)v;
                try {
                    int port = Integer.parseInt(value);
                    Preconditions.checkArgument(port > 0, "INVALID option %s:%s,as port ,>0 required", (Object)"mqtt", port);
                    this.activemqProperties.setProperty("pubsub.uri", String.format("mqtt://%s:%d", ActivemqContext.CONST_PROVIDER.getDefaultHost(), port));
                }
                catch (NumberFormatException e) {
                    HostAndPort hostAndPort;
                    try {
                        hostAndPort = HostAndPort.fromString(value).withDefaultPort(1883);
                    }
                    catch (IllegalArgumentException e2) {
                        try {
                            URI u = new URI(value);
                            URI r = URISupport.changeScheme(u, "mqtt");
                            this.activemqProperties.setProperty("pubsub.uri", r.toString());
                            return;
                        }
                        catch (URISyntaxException e1) {
                            throw new ParseException(String.format("INVALID value %s for option %s", value, "mqtt"));
                        }
                    }
                    this.activemqProperties.setProperty("pubsub.uri", String.format("mqtt://%s:%d", hostAndPort.getHost(), hostAndPort.getPort()));
                    return;
                }
            }
            Preconditions.checkState(Boolean.TRUE.equals(v), "INVALID VALUE TYPE FOR %s=%s", (Object)"mqtt", v);
            this.activemqProperties.setProperty("pubsub.uri", "mqtt://localhost:1883");
        }
    }

    public MQProperties getActivemqParameters() {
        return this.activemqProperties;
    }

    public String getMac() {
        return this.mac;
    }

    @Override
    protected String getAppName() {
        return SampleConsole.class.getSimpleName();
    }

    @Override
    protected String getHeader() {
        return "Text terminal for Dtalk Device(Dtalk\u8bbe\u5907\u4ea4\u4e92\u5b57\u7b26\u7ec8\u7aef)";
    }

    @Override
    protected void doAfterParse() {
        DefaultCustomActivemqConfigProvider.INIT_PROPERTIES.init(this.activemqProperties);
    }

    @Override
    protected Map<String, Object> doGetConstants() {
        return CONSTANTS;
    }

    public static void main(String[] args) {
        SampleConsole.run(new SampleConsoleActivemqConfig(), args);
    }
}

