/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.client;

import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import gu.dtalk.OptionType;
import gu.dtalk.client.SampleConsole;
import gu.dtalk.client.SampleConsoleConstants;
import gu.dtalk.redis.DefaultCustomRedisConfigProvider;
import gu.simplemq.MessageQueueType;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.JedisUtils;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.gdface.cli.BaseAppConfig;
import net.gdface.utils.ConditionChecks;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class SampleConsoleRedisConfig
extends BaseAppConfig
implements SampleConsoleConstants {
    private static final HashMap<String, Object> CONSTANTS = new HashMap<String, Object>(){
        {
            this.put("IMPL_TYPE", MessageQueueType.REDIS);
        }
    };
    private final Map<JedisPoolLazy.PropName, Object> redisParameters = JedisUtils.initParameters(null);
    private String mac;

    private SampleConsoleRedisConfig() {
        super(true);
        this.options.addOption(Option.builder().longOpt("host").desc("redis host name,default: localhost").numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("port").desc("redis port number,default: 6379").numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder("a").longOpt("auth").desc("redis password,default:empty").numberOfArgs(1).build());
        this.options.addOption(Option.builder().longOpt("db").desc("redis database index,default:00").numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder().longOpt("uri").desc("uri for redis,default:null").numberOfArgs(1).type(URI.class).build());
        this.options.addOption(Option.builder().longOpt("timeout").desc("redis timeout,default:2000 ms.").numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder().longOpt("mac").desc("MAC addres(hex)for target device,such as d0:17:c2:d0:3f:bf,default: self mac address").numberOfArgs(1).build());
        this.defaultValue.setProperty("host", null);
        this.defaultValue.setProperty("port", this.redisParameters.get((Object)JedisPoolLazy.PropName.port));
        this.defaultValue.setProperty("auth", null);
        this.defaultValue.setProperty("db", this.redisParameters.get((Object)JedisPoolLazy.PropName.database));
        this.defaultValue.setProperty("uri", null);
        this.defaultValue.setProperty("timeout", this.redisParameters.get((Object)JedisPoolLazy.PropName.timeout));
        this.defaultValue.setProperty("mac", "");
    }

    @Override
    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        super.loadConfig(options, cmd);
        this.redisParameters.put(JedisPoolLazy.PropName.host, this.getProperty("host"));
        if (this.hasProperty("port")) {
            this.redisParameters.put(JedisPoolLazy.PropName.port, ((Number)this.getProperty("port")).intValue());
        }
        this.redisParameters.put(JedisPoolLazy.PropName.password, this.getProperty("auth"));
        if (this.hasProperty("db")) {
            this.redisParameters.put(JedisPoolLazy.PropName.database, ((Number)this.getProperty("db")).intValue());
        }
        this.redisParameters.put(JedisPoolLazy.PropName.uri, this.getProperty("uri"));
        if (this.hasProperty("timeout")) {
            this.redisParameters.put(JedisPoolLazy.PropName.timeout, ((Number)this.getProperty("timeout")).intValue());
        }
        this.mac = (String)this.getProperty("mac");
        if (!Strings.isNullOrEmpty(this.mac)) {
            ConditionChecks.checkTrue(OptionType.MAC.strValidator.apply(this.mac), ParseException.class, "INVALID MAC address %s", (Object)this.mac);
            this.mac = this.mac.replaceAll("[:-]", "");
        }
    }

    public Map<JedisPoolLazy.PropName, Object> getRedisParameters() {
        return Maps.filterValues(this.redisParameters, Predicates.notNull());
    }

    public String getMac() {
        return this.mac;
    }

    @Override
    protected String getAppName() {
        return SampleConsole.class.getSimpleName();
    }

    @Override
    protected String getHeader() {
        return "Text terminal for Dtalk Device(Dtalk\u8bbe\u5907\u4ea4\u4e92\u5b57\u7b26\u7ec8\u7aef)";
    }

    @Override
    protected void doAfterParse() {
        DefaultCustomRedisConfigProvider.initredisParameters(this.getRedisParameters());
    }

    @Override
    protected Map<String, Object> doGetConstants() {
        return CONSTANTS;
    }

    public static void main(String[] args) {
        SampleConsole.run(new SampleConsoleRedisConfig(), args);
    }
}

