/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.client;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import gu.dtalk.Ack;
import gu.dtalk.BaseItem;
import gu.dtalk.BaseOption;
import gu.dtalk.CheckOption;
import gu.dtalk.MenuItem;
import gu.dtalk.client.IMessageRender;
import java.io.PrintStream;

public class TextRender
implements IMessageRender {
    private PrintStream stream = System.out;

    @Override
    public void rendeAck(Ack<?> ack, boolean renderValueIfOk) {
        Ack.Status status = ack.getStatus();
        if (renderValueIfOk && Ack.Status.OK == status && ack.getValue() != null) {
            Object v = ack.getValue();
            if (v instanceof JSONArray) {
                for (Object element : (JSONArray)v) {
                    this.stream.append(element.toString()).append("\n");
                }
            } else {
                this.stream.append(v.toString());
            }
        } else {
            this.stream.append(status.name());
            if (status != Ack.Status.OK && !Strings.isNullOrEmpty(ack.getStatusMessage())) {
                this.stream.append(":").append(ack.getStatusMessage());
            }
        }
        this.stream.append('\n');
    }

    @Override
    public void rendeItem(MenuItem menu) {
        this.stream.println("=========Device Menu============");
        this.stream.printf("-->%s\n", menu.getPath());
        int i = 0;
        for (BaseItem item : menu.getChilds()) {
            String acc = item.isDisable() ? "x" : " ";
            String hide = item.isHide() ? "[H]" : "   ";
            String content = "";
            if (item instanceof BaseOption) {
                BaseOption option = (BaseOption)item;
                content = MoreObjects.firstNonNull(option.contentOfValue(), "");
                String string = acc = option.isReadOnly() ? "R" : acc;
            }
            if (!content.isEmpty()) {
                content = ": " + content;
            }
            this.stream.printf("[%d] [%s] %s %s %s\n", i++, acc, hide, item.getUiName(), content);
            if (!(item instanceof CheckOption)) continue;
            CheckOption checkOption = (CheckOption)item;
            this.stream.println(checkOption.contentOfOptions());
        }
        this.stream.println("==Press number to seleect menu item,'.' show current menu(\u6309\u6570\u5b57\u9009\u9879\u83dc\u5355,'.'\u663e\u793a\u5f53\u524d\u83dc\u5355)==");
    }

    public IMessageRender setStream(PrintStream stream) {
        if (null != stream) {
            this.stream = stream;
        }
        return this;
    }

    public PrintStream getStream() {
        return this.stream;
    }
}

