/*
 * Decompiled with CFR 0.152.
 */
package gu.dtalk.redis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import gu.dtalk.redis.RedisConfigProvider;
import gu.dtalk.redis.RedisConfigType;
import gu.simplemq.redis.JedisPoolLazy;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class DefaultCustomRedisConfigProvider
implements RedisConfigProvider {
    private static final Map<JedisPoolLazy.PropName, Object> redisParameters = Maps.newHashMap();

    @Override
    public String getHost() {
        return (String)redisParameters.get((Object)JedisPoolLazy.PropName.host);
    }

    @Override
    public void setHost(String host) {
        redisParameters.put(JedisPoolLazy.PropName.host, host);
    }

    @Override
    public int getPort() {
        return MoreObjects.firstNonNull(redisParameters.get((Object)JedisPoolLazy.PropName.port), 0);
    }

    @Override
    public void setPort(int port) {
        redisParameters.put(JedisPoolLazy.PropName.port, port);
    }

    @Override
    public String getPassword() {
        return (String)redisParameters.get((Object)JedisPoolLazy.PropName.password);
    }

    @Override
    public void setPassword(String password) {
        redisParameters.put(JedisPoolLazy.PropName.password, password);
    }

    @Override
    public int getDatabase() {
        return MoreObjects.firstNonNull(redisParameters.get((Object)JedisPoolLazy.PropName.database), 0);
    }

    @Override
    public void setDatabase(int database) {
        redisParameters.put(JedisPoolLazy.PropName.database, database);
    }

    @Override
    public int getTimeout() {
        return MoreObjects.firstNonNull(redisParameters.get((Object)JedisPoolLazy.PropName.timeout), 0);
    }

    @Override
    public void setTimeout(int timeout) {
        redisParameters.put(JedisPoolLazy.PropName.timeout, timeout);
    }

    @Override
    public URI getURI() {
        return (URI)redisParameters.get((Object)JedisPoolLazy.PropName.uri);
    }

    @Override
    public void setURI(URI uri) {
        redisParameters.put(JedisPoolLazy.PropName.uri, uri);
    }

    @Override
    public final RedisConfigType type() {
        return RedisConfigType.CUSTOM;
    }

    public static void initredisParameters(Map<JedisPoolLazy.PropName, Object> redisParameters) {
        redisParameters = MoreObjects.firstNonNull(redisParameters, Collections.emptyMap());
        DefaultCustomRedisConfigProvider.redisParameters.clear();
        DefaultCustomRedisConfigProvider.redisParameters.putAll(redisParameters);
    }

    public static void setRedisLocation(URI redisLocation) {
        DefaultCustomRedisConfigProvider.initredisParameters(ImmutableMap.of(JedisPoolLazy.PropName.uri, Preconditions.checkNotNull(redisLocation, "redisLocation is null")));
    }

    public static Map<JedisPoolLazy.PropName, Object> readRedisparameters() {
        return Maps.filterValues(redisParameters, Predicates.notNull());
    }
}

