/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Preconditions;
import gu.simplemq.IMQContext;
import gu.simplemq.MessageQueueType;

public abstract class BaseMQContext
implements IMQContext {
    private final MessageQueueType mqType;
    private final String clientImplType;

    protected BaseMQContext(MessageQueueType mqType, String clientImplType) {
        this.mqType = Preconditions.checkNotNull(mqType, "checkNotNull is null");
        this.clientImplType = Preconditions.checkNotNull(clientImplType, "clientImplType is null");
    }

    @Override
    public final MessageQueueType getMessageQueueType() {
        return this.mqType;
    }

    @Override
    public final String getClientImplType() {
        return this.clientImplType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientImplType == null ? 0 : this.clientImplType.hashCode());
        result = 31 * result + (this.mqType == null ? 0 : this.mqType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseMQContext)) {
            return false;
        }
        BaseMQContext other = (BaseMQContext)obj;
        if (this.clientImplType == null ? other.clientImplType != null : !this.clientImplType.equals(other.clientImplType)) {
            return false;
        }
        return this.mqType == other.mqType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseMQContext [mqType=");
        builder.append((Object)this.mqType);
        builder.append(", clientImplType=");
        builder.append(this.clientImplType);
        builder.append("]");
        return builder.toString();
    }
}

