/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.simplemq.ChannelDispatcher;
import gu.simplemq.IConsumer;
import gu.simplemq.pool.BaseMQPool;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseMQDispatcher<C>
extends ChannelDispatcher
implements AutoCloseable,
IConsumer {
    protected final BaseMQPool<C> pool;
    private volatile C connection;
    private final AtomicBoolean closed = new AtomicBoolean(Boolean.FALSE);

    protected BaseMQDispatcher(BaseMQPool<C> pool) {
        this.pool = Preconditions.checkNotNull(pool, "pool is null");
    }

    protected C getConnection() {
        return Preconditions.checkNotNull(this.connection, "connection is uninitialized");
    }

    protected void doInit() throws Exception {
    }

    protected void doUninit() throws Exception {
    }

    protected abstract void doSub(String var1) throws Exception;

    protected abstract void doUnsub(String var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws Exception {
        if (null == this.connection) {
            BaseMQDispatcher baseMQDispatcher = this;
            synchronized (baseMQDispatcher) {
                if (null == this.connection) {
                    this.connection = this.pool.borrow();
                    this.doInit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninit() throws Exception {
        if (this.connection != null) {
            BaseMQDispatcher baseMQDispatcher = this;
            synchronized (baseMQDispatcher) {
                if (this.connection != null) {
                    this.doUninit();
                    if (!this.pool.isClosed()) {
                        this.pool.release(this.connection);
                    }
                    this.connection = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] subscribe(String ... channels) {
        BaseMQDispatcher baseMQDispatcher = this;
        synchronized (baseMQDispatcher) {
            channels = super.subscribe(channels);
            try {
                this.init();
                for (String name : channels) {
                    Preconditions.checkState(!Strings.isNullOrEmpty(name), "channel name is null or empty");
                    this.doSub(name);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            return channels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] unsubscribe(String ... channels) {
        BaseMQDispatcher baseMQDispatcher = this;
        synchronized (baseMQDispatcher) {
            channels = super.unsubscribe(channels);
            if (!this.pool.isClosed()) {
                for (String name : channels) {
                    try {
                        this.doUnsub(Preconditions.checkNotNull(name, "channel name is null"));
                    }
                    catch (Throwable e) {
                        if (this.closed.get()) continue;
                        e.printStackTrace();
                    }
                }
            }
            return channels;
        }
    }

    @Override
    public final void close() throws Exception {
        if (this.closed.compareAndSet(Boolean.FALSE, Boolean.TRUE)) {
            this.unsubscribe(new String[0]);
            this.uninit();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " [pool=");
        builder.append(this.pool);
        builder.append("]");
        return builder.toString();
    }
}

